# -*- coding: utf-8 -*-
import json
from sys import argv
from datetime import timedelta
try: from urllib import unquote
except ImportError: from urllib.parse import unquote
from caches.main_cache import main_cache
from modules import kodi_utils
# from modules.kodi_utils import logger

ls = kodi_utils.local_string
build_url = kodi_utils.build_url
make_listitem = kodi_utils.make_listitem
icon = kodi_utils.translate_path('special://home/addons/script.tikiart/resources/media/search.png')
fanart = kodi_utils.translate_path('special://home/addons/plugin.video.fen/fanart.png')

def add_to_search_history(search_name, search_list):
	try:
		result = []
		cache = main_cache.get(search_list)
		if cache: result = cache
		if search_name in result: result.remove(search_name)
		result.insert(0, search_name)
		result = result[:10]
		main_cache.set(search_list, result, expiration=timedelta(days=365))
	except: return

def remove_from_history(params):
	try:
		result = main_cache.get(params['setting_id'])
		result.remove(params.get('name'))
		main_cache.set(params['setting_id'], result, expiration=timedelta(days=365))
		kodi_utils.notification(32576, 3500)
		kodi_utils.execute_builtin('Container.Refresh')
	except: return

def clear_search_history():
	delete_str, search_str, hist_str, vid_str, mov_str = ls(32785), ls(32450), ls(32486), ls(32491), ls(32028)
	tv_str, aud_str, furk_str, easy_str, peop_str = ls(32029), ls(32492), ls(32069), ls(32070), ls(32507)
	choice_list = [('%s %s %s %s' % (delete_str, mov_str, search_str, hist_str), 'movie_queries', 'Movie'),
				   ('%s %s %s %s' % (delete_str, tv_str, search_str, hist_str), 'tvshow_queries', 'TV Show'), 
				   ('%s %s %s %s' % (delete_str, peop_str, search_str, hist_str), 'people_queries', 'People'),
				   ('%s %s %s %s %s' % (delete_str, furk_str, vid_str, search_str, hist_str), 'furk_video_queries', 'Furk Video'), 
				   ('%s %s %s %s %s' % (delete_str, furk_str, aud_str, search_str, hist_str), 'furk_audio_queries', 'Furk Audio'), 
				   ('%s %s %s %s' % (delete_str, easy_str, search_str, hist_str), 'easynews_video_queries', 'Easynews Video')]
	try:
		list_items = [{'line1': item[0], 'icon': icon} for item in choice_list]
		kwargs = {'items': json.dumps(list_items), 'heading': 'Fen', 'enumerate': 'false', 'multi_choice': 'false', 'multi_line': 'false'}
		setting = kodi_utils.select_dialog([item[1] for item in choice_list], **kwargs)
		if setting == None: return
		main_cache.set(setting, '', expiration=timedelta(days=365))
		kodi_utils.notification(32576, 3500)
	except: return

def search_history(params):
	def _builder():
		for h in history:
			try:
				cm = []
				name = unquote(h)
				url_params = {'mode': 'get_search_term', 'db_type': 'movie', 'query': name} if action == 'movie' \
						else {'mode': 'get_search_term', 'db_type': 'tv_show', 'query': name} if action == 'tvshow' \
						else {'mode': 'people_search.search', 'actor_name': name} if action == 'people' \
						else {'mode': 'furk.search_furk', 'db_type': 'video', 'query': name} if action == 'furk_video' \
						else {'mode': 'furk.search_furk', 'db_type': 'audio', 'music': True, 'query': name} if action == 'furk_audio' \
						else {'mode': 'easynews.search_easynews', 'query': name} if action == 'easynews_video' \
						else ''
				isFolder = False if action in ('movie', 'tvshow', 'people') else True
				display = '[B]%s %s : [/B]' % (display_title, sear_str) + name 
				url = build_url(url_params)
				cm.append((remove_str,'RunPlugin(%s)' % build_url({'mode': 'remove_from_history', 'setting_id':search_setting, 'name': name})))
				listitem = make_listitem()
				listitem.setLabel(display)
				listitem.setArt({'icon': icon, 'poster': icon, 'thumb': icon, 'fanart': fanart, 'banner': icon})
				listitem.addContextMenuItems(cm)
				yield (url, listitem, isFolder)
			except: pass
	__handle__ = int(argv[1])
	sear_str, mov_str, tv_str, peop_str = ls(32450).upper(), ls(32028).upper(), ls(32029).upper(), ls(32507).upper()
	furkvid_str = '%s %s' % (ls(32069).upper(), ls(32491).upper())
	furkaud_str = '%s %s' % (ls(32069).upper(), ls(32492).upper())
	remove_str, easy_str = ls(32786), ls(32070).upper()
	action = params['action']
	search_setting, display_title = {'movie': ('movie_queries', mov_str), 'tvshow': ('tvshow_queries', tv_str), 'people': ('people_queries', peop_str),
	'furk_video': ('furk_video_queries', furkvid_str), 'furk_audio': ('furk_audio_queries', furkaud_str), 'easynews_video': ('easynews_video_queries', easy_str)}[action]
	history = main_cache.get(search_setting)
	__handle__ = int(argv[1])
	kodi_utils.add_items(__handle__, list(_builder()))
	kodi_utils.set_content(__handle__, '')
	kodi_utils.end_directory(__handle__)
	kodi_utils.set_view_mode('view.main', '')
	