# -*- coding: utf-8 -*-
import xbmc, xbmcaddon
import sys, re, json, collections
import resources.lib.common as common

Addon = xbmcaddon.Addon(common.AddonID)
module = 'reshet'

baseUrl = 'https://13tv.co.il'
userAgent = "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/88.0.4324.146 Safari/537.36"
brvApi = 'https://edge.api.brightcove.com/playback/v1/accounts/1551111274001/videos/'
brvPk = 'application/json;pk=BCpkADawqM30eqkItS5d08jYUtMkbTKu99oEBllbfUaFKeknXu4iYsh75cRm2huJ_b1-pXEPuvItI-733TqJN1zENi-DcHlt7b4Dv6gCT8T3BS-ampD0XMnORQLoLvjvxD14AseHxvk0esW3'
cstApi = 'https://13tv-api.oplayer.io/api/getlink'
cstUserId = '45E4A9FB-FCE8-88BF-93CC-3650C39DDF28'
moduleIcon = common.GetIconFullPath("13.jpg")

def GetCategoriesList(iconimage):
	name = "{0}: {1}".format(common.GetLocaleString(30001), common.GetLocaleString(30002) if sortBy == 0 else common.GetLocaleString(30003))
	common.addDir(name, "toggleSortingMethod", 5, iconimage, {"Title": name, "Plot": "{0}[CR]{1}[CR]{2} / {3}".format(name, common.GetLocaleString(30004), common.GetLocaleString(30002), common.GetLocaleString(30003))}, module=module, isFolder=False)
	result = GetUrlJson('{0}/vod/'.format(baseUrl))
	if len(result) > 0:
		name = common.GetLabelColor("כל התכניות", bold=True, color="none")
		common.addDir(name, '{0}/vod/'.format(baseUrl), 0, iconimage, infos={"Title": name, "Plot": "צפיה בתכניות רשת 13"}, module=module)
		#name = common.GetLabelColor(common.UnEscapeXML(common.encode('פרקים אחרונים', 'utf-8')), bold=True, color="none")
		#common.addDir(name, '{0}/general/programs/signup-auditions/'.format(baseUrl), 1, iconimage, infos={"Title": name, "Plot": "צפיה בפרקים אחרונים מתכניות רשת 13"}, module=module)
		grids = result.get('Content', {}).get('PageGrid', {})
		for grid in grids:
			gridType = grid.get('GridType')
			if gridType is not None and gridType == 'grid_content_4col' or gridType == 'carousel_grid_content':
				gridTitle = common.encode(grid.get('GridTitle').get('title').strip(), 'utf-8')
				name = common.GetLabelColor(gridTitle, bold=True, color="none")
				grid_id = grid.get('grid_id', '-1')
				if grid_id == '-1' or grid_id == 655201 or grid_id == 2015588:
					continue
				common.addDir(name, str(grid_id), 6, iconimage, infos={"Title": name}, module=module)
	name = common.GetLabelColor("חדשות 13", bold=True, color="none")
	common.addDir(name, '', 10, iconimage, infos={"Title": name, "Plot": "צפיה בתכניות חדשות 13"}, module=module)
	name = common.GetLabelColor("ארכיון רשת 13", bold=True, color="none")
	common.addDir(name, '{0}/general/programs/'.format(baseUrl), 0, iconimage, infos={"Title": name, "Plot": "צפיה בתכניות מארכיון רשת 13"}, module=module)

def GetUrlJson(url):
	result = {}
	try:
		html = common.OpenURL(url, headers={'User-Agent': userAgent, 'Accept-encoding': 'gzip, deflate, br'})
		data_query = re.compile('data_query = (.*?)\.data_query;', re.S).findall(html)
		#xbmc.log(data_query[0], 5)
		result = json.loads(data_query[0])['data_query'] if len(data_query) > 0 else {}
	except Exception as ex:
		xbmc.log(str(ex), 3)
	return result

def GetIcon(images, iconimage):
	if images == None:
		return iconimage
	icon = images.get('app_16x9')
	if icon == None:
		icon = images.get('src', iconimage)
	if icon == None or icon == False or icon == '':
		icon = iconimage
	return common.encode(icon, 'utf-8')

def GetGridList(iconimage, grid_id):
	url = '{0}/vod/'.format(baseUrl)
	result = GetUrlJson(url)
	if len(result) < 1:
		return
	episodes = []
	series = []
	postsIDs = []
	posts = {}
	grids = result.get('Content', {}).get('PageGrid', {})
	for grid in grids:
		if grid.get('grid_id') != int(grid_id):
			continue
		gridType = grid.get('GridType')
		if gridType is None or 'grid_content' not in gridType:
			continue
		title = grid.get('GridTitle')
		gridTitle = '' if title is None else common.encode(title.get('title', '').strip(), 'utf-8')
		titleLink = '' if title is None else title.get('link', '')
		gridLink = '' if titleLink is None else common.encode(str(titleLink).strip(), 'utf-8')
		if gridLink != '' and gridTitle != '' and gridLink != url:
			series.append((gridTitle, gridLink, iconimage, '', ''))
		for postsID in grid.get('Posts', {}):
			try:
				if postsID in postsIDs:
					continue
				post = result.get('ItemStore', {}).get(str(postsID), {})
				link = post.get('link')
				title = common.encode(post['title'], 'utf-8')
				subtitle = common.encode(post['subtitle'], 'utf-8')
				icon = GetIcon(post['images'], iconimage)
				publishDate = post.get('publishDate')
				postType = post.get('postType', '')
				if postType == 'item':
					mode = 3
					video = post.get('video')
					if video is None:
						continue
					link = ''
					if video.get('kaltura_videoID') is not None:
						link = '{0}--kaltura--{1}==='.format(link, video['kaltura_videoID'])
					if video.get('cst_videoID') is not None:
						if video['cst_videoID'] == '-1':
							link = '{0}--cst--{1}==='.format(link, video['cst_videoID'])
						else:
							link = '{0}--cst--{1}==='.format(link, video.get('videoRef', link))
					if video.get('brv_videoID') is not None:
						link = '{0}--brv--{1}==='.format(link, video['brv_videoID'])	
					if link == '':
						continue
				elif postType != 'page':
					continue
				else:
					mode = 1
					#categoryLabel = post.get('CategoryLabel', '')
					#if categoryLabel != '':
					#	title = common.encode(categoryLabel, 'utf-8')
					titleForGrid = post.get('gridView', {}).get('titleForGrid', '')
					if titleForGrid != '':
						title = common.encode(titleForGrid, 'utf-8')
				if link == '' or link in posts:
					continue
				posts[link] = title
				postsIDs.append(postsID)
				
				if mode == 1:
					series.append((title, link, icon, subtitle, publishDate))
				else:
					episodes.append((title, gridTitle, link, icon, subtitle, publishDate))
			except Exception as ex:
				xbmc.log(str(ex), 3)
		break
	if sortBy == 1:
		series = sorted(series,key=lambda series: series[0])
		#episodes = sorted(episodes,key=lambda episodes: episodes[0])
	for title, link, icon, subtitle, publishDate in series:
		name = common.GetLabelColor(title, keyColor="prColor", bold=True)
		link = str(link)
		infos= {"Title": name, "Plot": subtitle, "Aired": publishDate}
		common.addDir(name, link, 1, icon, infos=infos, module=module)
	for title, gridTitle, link, icon, subtitle, publishDate in episodes:
		name = common.GetLabelColor(title, keyColor="chColor") if gridTitle is None or gridTitle == '' else common.getDisplayName(gridTitle, title, programNameFormat)
		link = str(link)
		infos= {"Title": name, "Plot": subtitle, "Aired": publishDate}
		common.addDir(name, link, 3, icon, infos=infos, contextMenu=[(common.GetLocaleString(30005), 'RunPlugin({0}?url={1}&name={2}&mode=3&iconimage={3}&moredata=choose&module=reshet)'.format(sys.argv[0], common.quote_plus(link), common.quote_plus(name), common.quote_plus(icon))), (common.GetLocaleString(30023), 'RunPlugin({0}?url={1}&name={2}&mode=3&iconimage={3}&moredata=set_reshet_res&module=reshet)'.format(sys.argv[0], common.quote_plus(link), common.quote_plus(name), common.quote_plus(icon)))], moreData=bitrate, module=module, isFolder=False, isPlayable=True)

def GetSeriesList(url, iconimage):
	result = GetUrlJson(url)
	if len(result) < 1:
		return
	grids_arr = []
	seriesIDs = []
	series = {}
	grids = result.get('Content', {}).get('PageGrid', {})
	for grid in grids:
		for seriesID in grid.get('Posts', {}):
			try:
				if seriesID in seriesIDs or seriesID == 170768:
					continue
				serie = result.get('ItemStore', {}).get(str(seriesID), {})
				link = serie.get('link')
				postType = serie.get('postType', '')
				if postType == 'item':
					if '/movies/' in link:
						link = link[:link.find('/movies/') + 8].replace('/item', '')
					else:
						link = link[:link.find('/season') + 1].replace('/item', '')
					name = common.encode(serie['title'], 'utf-8')
					name = name[:name.find(',')]
				elif postType != 'page':
					continue
				else:
					if len(common.url_parse(link).path.split('/')) > 4 and 'channel2-news' not in link:
						continue
					name = common.encode(serie['title'], 'utf-8')
				name = common.GetLabelColor(name, keyColor="prColor", bold=True)
				if link == '' or link in series and postType != 'page':
					continue
				series[link] = name
				seriesIDs.append(seriesID)
				pageTitle = serie.get('pageTitle', {})
				description = '' if pageTitle is None else common.encode(pageTitle.get('description', ''), 'utf-8')
				matches = [grids_arr.index(x) for x in grids_arr if link == x[1]]
				if len(matches) == 1:
					grids_arr[matches[0]] = (name, link, GetIcon(serie['images'], str(grids_arr[matches[0]][2])), {"Title": name, "Plot": description,'mediatype': 'movie'})
				else:
					grids_arr.append((name, link, GetIcon(serie['images'], iconimage), {"Title": name, "Plot": description,'mediatype': 'movie'}))
			except Exception as ex:
				xbmc.log('SerieID: {0}\n{1}'.format(seriesID, str(ex)), 3)
	mainMenus = result.get('Header', {}).get('mainMenu', [])
	for mainMenu in mainMenus:
		if mainMenu['url'] == '{0}/vod/'.format(baseUrl):
			grids = mainMenu['children']
			for grid in grids:
				name = common.GetLabelColor(common.UnEscapeXML(common.encode(grid['title'], 'utf-8')), keyColor="prColor", bold=True)
				link = grid['url']
				if link == '' or link in series or link == '{0}/vod/'.format(baseUrl) or link == '{0}/general/programs/signup-auditions/'.format(baseUrl):
					continue
				series[link] = name
				grids_arr.append((name, link, iconimage, {"Title": name}))
	grids_sorted = grids_arr if sortBy == 0 else sorted(grids_arr,key=lambda grids_arr: grids_arr[0])
	for name, link, icon, infos in grids_sorted:
		common.addDir(name, link, 1, str(icon), infos=infos, module=module)
	
def GetSeasonList(url, iconimage):
	result = GetUrlJson(url)
	seasons, episodes = GetLinks(url, result, iconimage)
	if len(seasons) > 0:
		for link, title in common.items(seasons):
			name = common.GetLabelColor(title, keyColor="timesColor", bold=True)
			common.addDir(name, link, 1, iconimage, infos={"Title": name}, module=module)
		if len(episodes) < 1:
			return
	ShowEpisodes(episodes, iconimage)
	ShowPaging(result, iconimage)

def GetEpisodesList(url, iconimage):
	result = GetUrlJson(url)
	seasons, episodes = GetLinks(url, result, iconimage)
	for link, title in common.items(seasons):
		if 'reshet.tv/news/tonight/' in link:
			name = 'אין פרקים מלאים'
			common.addDir(name, '', 99, iconimage, infos={"Title": name}, module=module, isFolder=False)
			return
	ShowEpisodes(episodes, iconimage)
	ShowPaging(result, iconimage)

def IsLinkNotExist(url, link, seasons):
	return url != link and url in link and link.replace('episodes/', '') not in seasons and (link not in seasons or seasons[link] == '')

def GetLinks(url, result, iconimage):
	seasons = collections.OrderedDict() if common.NewerThanPyVer('2.6.99') else {}
	episodes = []
	subMenus = result.get('Header', {}).get('subMenu', {})
	if subMenus:
		for subMenu in subMenus:
			try:
				title = subMenu.get('title')
				link = subMenu.get('url')
				if len(link) > 0 and link[-1] != '/':
					link += '/'
				ending = link[link.rfind('/', 0, len(link)-1):]
				if ('episodes' in ending or 'season' in ending) and IsLinkNotExist(url, link, seasons):
					#link = GetLink(link)
					seasons[link] = common.encode(title.strip(), 'utf-8')
					#xbmc.log('!! {0} - {1} !!'.format(link, seasons[link]), 5)
			except Exception as ex:
				xbmc.log(str(ex), 3)
	grids = result.get('Content', {}).get('PageGrid', {})
	for grid in grids:
		title = grid.get('GridTitle')
		gridTitle = '' if title is None else common.encode(title.get('title', '').strip(), 'utf-8')
		titleLink = '' if title is None else title.get('link', '')
		gridLink = '' if titleLink is None else common.encode(str(titleLink).strip(), 'utf-8')
		if len(gridLink) > 0 and gridLink[-1] != '/':
			gridLink += '/'
		#xbmc.log('-- {0} - {1} --'.format(gridLink, gridTitle), 5)
		if 'episodes' in gridLink and IsLinkNotExist(url, gridLink, seasons):
			#gridLink = GetLink(gridLink)
			seasons[gridLink] = gridTitle if gridTitle != '' else common.encode(result.get('PageMeta', {}).get('title', '').strip(), 'utf-8')
			#xbmc.log('@@ {0} - {1} @@'.format(gridLink, seasons[gridLink]), 5)
		elif gridLink != '' and gridTitle != '' and IsLinkNotExist(url, gridLink, seasons):
			#gridLink = gridLink.replace('/episodes/', '')
			seasons[gridLink] = gridTitle
			#xbmc.log('## {0} - {1} ##'.format(gridLink, seasons[gridLink]), 5)
		for pid in grid.get('Posts', {}):
			try:
				post = result.get('ItemStore', {}).get(str(pid), {})
				link = post.get('link', '').replace('vod-2', 'vod').replace('/channel2/', '/channel2-news/')
				if len(link) > 0 and link[-1] != '/':
					link += '/'
				if 'episodes' not in link and '/movies/' not in link:
					ending = link[link.rfind('/', 0, len(link)-1):]
					if 'season' in ending and IsLinkNotExist(url, link, seasons):
						#link = GetLink(link)
						seasons[link] = common.encode(post.get('title', '').strip(), 'utf-8')
						#xbmc.log('$$ {0} - {1} $$'.format(link, seasons[link]), 5)
					if post['postType'] != 'item':
						continue
				if 'links' in post['postType'] and IsLinkNotExist(url, link, seasons):
					#link = GetLink(link)
					seasons[link] = common.encode(post.get('title', '').strip(), 'utf-8')
					#xbmc.log('%% {0} - {1} %%'.format(link, seasons[link]), 5)
				else:
					if '/episodes/' in link:
						seasonsLink = link[:link.find('/episodes/') + 10].replace('/item', '')
						#match = re.compile('/season-(\d+)(.*?)/(.*?)').findall(seasonsLink)
						#if len(match) > 0 and match[0][1] != '' and match[0][1] != '-vip':
						#	seasonsLink = GetLink(seasonsLink.replace(match[0][1], ''))
						if '/movies/' not in seasonsLink and IsLinkNotExist(url, seasonsLink, seasons):
							coolaData = post.get('coolaData')
							if coolaData is None:
								title = common.encode(post['category'][0].get('title', '').strip(), 'utf-8')
							else:
								page_2_level_heb = coolaData.get('page_2_level_heb')
								page_2_level_heb = '' if page_2_level_heb is None else common.encode(page_2_level_heb, 'utf-8')
								page_3_level_heb = coolaData.get('page_3_level_heb')
								page_3_level_heb = '' if page_3_level_heb is None else common.encode(page_3_level_heb, 'utf-8')
								page_4_level_heb = coolaData.get('page_4_level_heb')
								page_4_level_heb = '' if page_4_level_heb is None else common.encode(page_4_level_heb, 'utf-8')
								title = '{0} {1} {2}'.format(page_2_level_heb, page_3_level_heb, page_4_level_heb)
							seasons[seasonsLink] = title
							#xbmc.log('^^ {0} - {1} ^^'.format(seasonsLink, seasons[seasonsLink]), 5)
					video = post.get('video')
					if video is None:
						continue
					videoID = ''
					if video.get('kaltura_videoID') is not None:
						videoID = '{0}--kaltura--{1}==='.format(videoID, video['kaltura_videoID'])
					if video.get('cst_videoID') is not None:
						if video['cst_videoID'] == '-1':
							videoID = '{0}--cst--{1}==='.format(videoID, video['cst_videoID'])
						else:
							videoID = '{0}--cst--{1}==='.format(videoID, video.get('videoRef', videoID))
					if video.get('brv_videoID') is not None:
						videoID = '{0}--brv--{1}==='.format(videoID, video['brv_videoID'])	
					if videoID == '':
						continue
					icon =  GetIcon(post['images'], iconimage)
					episodes.append((gridTitle, videoID, icon, common.encode(post.get('title', '').strip(), 'utf-8'), common.encode(post.get('subtitle', '').strip(), 'utf-8'), post.get('publishDate')))
			except Exception as ex:
				xbmc.log(str(ex), 3)
	#xbmc.log(str(seasons), 5)
	return seasons, episodes

def ShowEpisodes(episodes, iconimage):
	if len(episodes) < 1:
		name = 'אין פרקים מלאים'
		common.addDir(name, '', 99, iconimage, infos={"Title": name}, module=module, isFolder=False)
		return
	#for gridTitle, link, icon, title, subtitle, publishDate in sorted(episodes,key=lambda episodes: episodes[5]):#reversed(episodes):
	for gridTitle, link, icon, title, subtitle, publishDate in episodes:
		name = common.GetLabelColor(title, keyColor="chColor") if gridTitle is None or gridTitle == '' else common.getDisplayName(gridTitle, title, programNameFormat)
		link = str(link)
		common.addDir(name, link, 3, icon, infos={"Title": name, "Plot": subtitle, "Aired": publishDate}, contextMenu=[(common.GetLocaleString(30005), 'RunPlugin({0}?url={1}&name={2}&mode=3&iconimage={3}&moredata=choose&module=reshet)'.format(sys.argv[0], common.quote_plus(link), common.quote_plus(name), common.quote_plus(icon))), (common.GetLocaleString(30023), 'RunPlugin({0}?url={1}&name={2}&mode=3&iconimage={3}&moredata=set_reshet_res&module=reshet)'.format(sys.argv[0], common.quote_plus(link), common.quote_plus(name), common.quote_plus(icon)))], moreData=bitrate, module=module, isFolder=False, isPlayable=True)

def ShowPaging(result, iconimage):
	grids = result.get('Content', {}).get('PageGrid', {})
	if len(grids) < 1:
		return
	WpQuery = grids[-1].get('WpQuery', None)
	if WpQuery is None:
		paged = 0  
	else: 
		paged = WpQuery.get('paged', 0)
	if paged > 0:
		page_url = result.get('PageMeta', {}).get('page_url', '')
		max_page = grids[-1].get('max_page', 0)
		if paged > 1:
			prev_page = page_url + 'page/' + str(paged-1) + '/' if paged - 1 > 1 else page_url
			common.addDir(common.GetLabelColor(common.GetLocaleString(30011), color="green"), prev_page, 2, iconimage, module=module)
		if max_page > paged:
			common.addDir(common.GetLabelColor(common.GetLocaleString(30012), color="green"), page_url + 'page/' + str(paged+1) + '/', 2, iconimage, module=module)

def Play(video, name='', iconimage='', quality='best'):
	try:
		videos = video.split('===')
		kaltura = ''
		cst = ''
		brv = ''
		for vid in videos:
			if '--kaltura--' in vid:
				kaltura = vid.replace('--kaltura--', '')
			elif '--cst--' in vid:
				cst = vid.replace('--cst--', '')
			elif '--brv--' in vid:
				brv = vid.replace('--brv--', '')
		if kaltura != '':
			link = common.GetKaltura(kaltura, 2748741, baseUrl, userAgent, quality=quality)
		elif cst != '':
			headers={"User-Agent": userAgent}
			if common.isnumeric(cst):
				result = common.OpenURL('{0}/getVideoById?userId={1}&serverType=web&videoId={2}&callback=x'.format(cstApi, cstUserId, cst), headers=headers)
			else:
				result = common.OpenURL('{0}/getlink/getVideoByFileName?userId={1}&videoName={2}&serverType=web&callback=x'.format(cstApi, cstUserId, cst), headers=headers)
			if result is not None:
				source = json.loads(result)[0]
				link = '{0}{1}{2}{3}{4}.mp4{5}{6}'.format(source['ProtocolType'], source['ServerAddress'], source['MediaRoot'], source['MediaFile'][:source['MediaFile'].find('.mp4')], source['Bitrates'], source['StreamingType'], source['Token'])
				#xbmc.log(link, 5)
				session = common.GetSession()
				link = common.GetStreams(link, headers=headers, session=session, quality=quality)
				final = '{0}|User-Agent={1}'.format(link, userAgent)
				cookies = "&".join(['Cookie={0}'.format(common.quote('{0}={1}'.format(_cookie.name, _cookie.value))) for _cookie in session.cookies])
				if cookies != '':
					final = '{0}&{1}'.format(final, cookies)
			else:
				result = common.OpenURL('{0}{1}'.format(brvApi, brv), headers={"Accept": brvPk, "User-Agent": userAgent})
				if result is None:
					link = 'https://c.brightcove.com/services/mobile/streaming/index/master.m3u8?videoId={0}'.format(brv)
					link = common.GetStreams(link, headers=headers, quality=quality)
				else:
					sources = json.loads(result)['sources']
					link = ''
					avg_bitrate = 0
					for source in sources:
						if 'src' in source:
							if source['container'] == 'M2TS':
								link = common.GetStreams(source['src'], headers=headers, quality=quality)
								break
							if source['avg_bitrate'] > avg_bitrate:
								link = source['src']
								avg_bitrate = source['avg_bitrate']
								#xbmc.log('[{0}]  {1}'.format(avg_bitrate, link), 5)
				final = '{0}|User-Agent={1}'.format(link, userAgent)
		
		final = '{0}|User-Agent={1}'.format(link, userAgent)
		common.PlayStream(final, quality, name, iconimage)
	except Exception as ex:
		xbmc.log(str(ex), 3)

def WatchLive(url, name='', iconimage='', quality='best'):
	channels = {
		'13': {'brv': 'videoId', 'cst': '1', 'klt': '1_ubg28z0w', 'referer': '{0}/live/'.format(baseUrl), 'link': 'https://d18b0e6mopany4.cloudfront.net/out/v1/08bc71cf0a0f4712b6b03c732b0e6d25/index.m3u8'},
		'13c': {'brv': 'accessibility_ref', 'cst': '27', 'klt': '1_8dlti2jz', 'referer': '{0}/live/'.format(baseUrl), 'link': 'https://d198ztbnlup2iq.cloudfront.net/out/v1/2d9050c90fb94df8b78d1d98306a1a65/index.m3u8'},
		'bb': {'brv': 'videoId', 'cst': '26', 'klt': '1_6fr5xbw2', 'referer': '{0}/home/bb-livestream/'.format(baseUrl), 'link': 'https://d2lckchr9cxrss.cloudfront.net/out/v1/c73af7694cce4767888c08a7534b503c/index.m3u8'}
	}
	referer = channels[url]['referer']
	try:
		'''
		result = GetUrlJson(referer)
		provider = result['Header']['Live']['extras']['live_video_provider']
		if provider == 'cast_time':
			result = common.OpenURL('{0}/?userId={1}&serverType=web&cdnName=casttime&ch={2}'.format(cstApi, cstUserId, channels[url]['cst']), headers={"User-Agent": userAgent})
			link = json.loads(result)[0]['Link']
		else:
			result = common.OpenURL('{0}{1}'.format(brvApi, result['Header']['Live'][channels[url]['brv']]), headers={"Accept": brvPk, "User-Agent": userAgent})
			link = json.loads(result)['sources'][0]['src']
		'''
		link = common.GetKaltura(channels[url]['klt'], 2748741, baseUrl, userAgent, quality=quality)
		if link == '':
			link = common.GetStreams(channels[url]['link'], headers={"User-Agent": userAgent, 'Referer': referer}, quality=quality)
	except Exception as ex:
		xbmc.log(str(ex), 3)
		link = common.GetStreams(channels[url]['link'], headers={"User-Agent": userAgent, 'Referer': referer}, quality=quality)
	final = '{0}|User-Agent={1}&Referer={2}'.format(link, userAgent, referer)
	common.PlayStream(final, quality, name, iconimage)

def GetNewsCategoriesList(iconimage):
	url = '{0}/news/13-programs/'.format(baseUrl)
	result = GetUrlJson(url)
	if len(result) < 1:
		return
	grids_arr = []
	mainMenus = result.get('Header', {}).get('mainMenu', [])
	for mainMenu in mainMenus:
		if mainMenu['url'] == url:
			grids = mainMenu['children']
			for grid in grids:
				name = common.GetLabelColor(common.UnEscapeXML(common.encode(grid['title'], 'utf-8')), keyColor="prColor", bold=True)
				link = grid['url']
				grids_arr.append((name, link, iconimage, {"Title": name}))
	grids_sorted = grids_arr if sortBy == 0 else sorted(grids_arr,key=lambda grids_arr: grids_arr[0])
	for name, link, icon, infos in grids_sorted:
		common.addDir(name, link, 1, icon, infos=infos, module=module)

def Run(name, url, mode, iconimage='', moreData=''):
	global sortBy, bitrate, programNameFormat
	sortBy = int(common.GetAddonSetting('{0}SortBy'.format(module)))
	bitrate = common.GetAddonSetting('{0}_res'.format(module))
	programNameFormat = int(common.GetAddonSetting("programNameFormat"))
	
	if mode == -1:
		GetCategoriesList(moduleIcon)
	elif mode == 0:
		GetSeriesList(url, moduleIcon)					# Series
	elif mode == 1:
		GetSeasonList(url, iconimage)					# Seasons
	elif mode == 2:
		GetEpisodesList(url, iconimage)					# Episodes
	elif mode == 3:
		Play(url, name, iconimage, moreData)			# Playing episode
	elif mode == 4:
		WatchLive(url, name, iconimage, moreData)		# Playing Live
	elif mode == 5:	
		common.ToggleSortMethod('reshetSortBy', sortBy)	# Toggle Lists' sorting method
	elif mode == 6:
		GetGridList(moduleIcon, url)
	elif mode == 10:
		GetNewsCategoriesList(moduleIcon)					# News Shows
	
	common.SetViewMode('episodes')
