# -*- coding: utf-8 -*-

# Below is the contents of the providers/__init__.py base64 encoded
# If you update this init file you will need to update this base64 as well to ensure it is deployed on the users machine
# If you change the init file without updating this it will be overwritten with the old one!!

init_contents = 'aW1wb3J0IG9zCmZyb20gcmVzb3VyY2VzLmxpYi5jb21tb24gaW1wb3J0IHRvb2xzCmZyb20gcmVzb3VyY2VzLmxpYi5tb2R1bG' \
                'VzIGltcG9ydCBkYXRhYmFzZQoKZGF0YV9wYXRoID0gb3MucGF0aC5qb2luKHRvb2xzLmRhdGFQYXRoLCAncHJvdmlkZXJzJykKa' \
                'G9zdGVyX3NvdXJjZXMgPSBbXQp0b3JyZW50X3NvdXJjZXMgPSBbXQoKZGVmIGdldF9yZWxldmFudChsYW5ndWFnZSk6CiAgICBw' \
                'cm92aWRlcl9wYWNrYWdlcyA9IFtuYW1lIGZvciBuYW1lIGluIG9zLmxpc3RkaXIoZGF0YV9wYXRoKSBpZiBvcy5wYXRoLmlzZGly' \
                'KG9zLnBhdGguam9pbihkYXRhX3BhdGgsIG5hbWUpKV0KICAgICMgR2V0IHJlbGV2YW50IGFuZCBlbmFibGVkIHByb3ZpZGVyIGVu' \
                'dHJpZXMgZnJvbSB0aGUgZGF0YWJhc2UKICAgIHByb3ZpZGVyX3N0YXR1cyA9IFtpIGZvciBpIGluIGRhdGFiYXNlLmdldF9wcm92' \
                'aWRlcnMoKSBpZiBpWydjb3VudHJ5J10gPT0gbGFuZ3VhZ2VdCiAgICBwcm92aWRlcl9zdGF0dXMgPSBbaSBmb3IgaSBpbiBwcm92' \
                'aWRlcl9zdGF0dXMgaWYgaVsnc3RhdHVzJ10gPT0gJ2VuYWJsZWQnXQoKICAgIGZvciBwYWNrYWdlIGluIHByb3ZpZGVyX3BhY2th' \
                'Z2VzOgogICAgICAgIHRyeToKICAgICAgICAgICAgcHJvdmlkZXJzX3BhdGggPSAncHJvdmlkZXJzLiVzLiVzJyAlIChwYWNrYWdl' \
                'LCBsYW5ndWFnZSkKICAgICAgICAgICAgdHJ5OgogICAgICAgICAgICAgICAgcHJvdmlkZXJfbGlzdCA9IF9faW1wb3J0X18ocHJv' \
                'dmlkZXJzX3BhdGgsIGZyb21saXN0PVsnJ10pCiAgICAgICAgICAgIGV4Y2VwdDoKICAgICAgICAgICAgICAgIGNvbnRpbnVlCiAg' \
                'ICAgICAgICAgIHRyeToKICAgICAgICAgICAgICAgIGZvciBpIGluIHByb3ZpZGVyX2xpc3QuZ2V0X2hvc3RlcnMoKToKICAgICAg' \
                'ICAgICAgICAgICAgICBmb3Igc3RhdHVzIGluIHByb3ZpZGVyX3N0YXR1czoKICAgICAgICAgICAgICAgICAgICAgICAgaWYgaSA9' \
                'PSBzdGF0dXNbJ3Byb3ZpZGVyX25hbWUnXToKICAgICAgICAgICAgICAgICAgICAgICAgICAgIGlmIHBhY2thZ2UgPT0gc3RhdHVz' \
                'WydwYWNrYWdlJ106CiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIyBBZGQgaW1wb3J0IHBhdGggYW5kIG5hbWUgdG8g' \
                'aG9zdGVyX3Byb3ZpZGVycwogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIGhvc3Rlcl9zb3VyY2VzLmFwcGVuZCgoJyVz' \
                'Lmhvc3RlcnMnICUgcHJvdmlkZXJzX3BhdGgsIGksIHBhY2thZ2UpKQogICAgICAgICAgICBleGNlcHQ6CiAgICAgICAgICAgICAg' \
                'ICBwYXNzCiAgICAgICAgICAgIAogICAgICAgICAgICB0cnk6CiAgICAgICAgICAgICAgICBmb3IgaSBpbiBwcm92aWRlcl9saXN0' \
                'LmdldF90b3JyZW50KCk6CiAgICAgICAgICAgICAgICAgICAgZm9yIHN0YXR1cyBpbiBwcm92aWRlcl9zdGF0dXM6CiAgICAgICAg' \
                'ICAgICAgICAgICAgICAgIGlmIGkgPT0gc3RhdHVzWydwcm92aWRlcl9uYW1lJ106CiAgICAgICAgICAgICAgICAgICAgICAgICAg' \
                'ICBpZiBwYWNrYWdlID09IHN0YXR1c1sncGFja2FnZSddOgogICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICMgQWRkIGlt' \
                'cG9ydCBwYXRoIGFuZCBuYW1lIHRvIHRvcnJlbnRfcHJvdmlkZXJzCiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgdG9y' \
                'cmVudF9zb3VyY2VzLmFwcGVuZCgoJyVzLnRvcnJlbnQnICUgcHJvdmlkZXJzX3BhdGgsIGksIHBhY2thZ2UpKQogICAgICAgICAg' \
                'ICBleGNlcHQ6CiAgICAgICAgICAgICAgICBwYXNzCiAgICAgICAgZXhjZXB0OgogICAgICAgICAgICBpbXBvcnQgdHJhY2ViYWNr' \
                'CiAgICAgICAgICAgIHRyYWNlYmFjay5wcmludF9leGMoKQogICAgICAgICAgICBjb250aW51ZQoKICAgIHJldHVybiAodG9ycmVu' \
                'dF9zb3VyY2VzLCBob3N0ZXJfc291cmNlcykKCmRlZiBnZXRfYWxsKGxhbmd1YWdlKToKICAgIHByb3ZpZGVyX3BhY2thZ2VzID0g' \
                'W25hbWUgZm9yIG5hbWUgaW4gb3MubGlzdGRpcihkYXRhX3BhdGgpIGlmIG9zLnBhdGguaXNkaXIob3MucGF0aC5qb2luKGRhdGFf' \
                'cGF0aCwgbmFtZSkpXQogICAgZm9yIHBhY2thZ2UgaW4gcHJvdmlkZXJfcGFja2FnZXM6CiAgICAgICAgdHJ5OgogICAgICAgICAg' \
                'ICBwcm92aWRlcnNfcGF0aCA9ICdwcm92aWRlcnMuJXMuJXMnICUgKHBhY2thZ2UsIGxhbmd1YWdlKQogICAgICAgICAgICB0cnk6' \
                'CiAgICAgICAgICAgICAgICBwcm92aWRlcl9saXN0ID0gX19pbXBvcnRfXyhwcm92aWRlcnNfcGF0aCwgZnJvbWxpc3Q9WycnXSkK' \
                'ICAgICAgICAgICAgZXhjZXB0OgogICAgICAgICAgICAgICAgY29udGludWUKICAgICAgICAgICAgdHJ5OgogICAgICAgICAgICAg' \
                'ICAgZm9yIGkgaW4gcHJvdmlkZXJfbGlzdC5nZXRfaG9zdGVycygpOgogICAgICAgICAgICAgICAgICAgIGhvc3Rlcl9zb3VyY2Vz' \
                'LmFwcGVuZCgoJyVzLmhvc3RlcnMnICUgcHJvdmlkZXJzX3BhdGgsIGksIHBhY2thZ2UpKQogICAgICAgICAgICBleGNlcHQ6CiAg' \
                'ICAgICAgICAgICAgICBwYXNzCgogICAgICAgICAgICB0cnk6CiAgICAgICAgICAgICAgICBmb3IgaSBpbiBwcm92aWRlcl9saXN0' \
                'LmdldF90b3JyZW50KCk6CiAgICAgICAgICAgICAgICAgICAgdG9ycmVudF9zb3VyY2VzLmFwcGVuZCgoJyVzLnRvcnJlbnQnICUg' \
                'cHJvdmlkZXJzX3BhdGgsIGksIHBhY2thZ2UpKQogICAgICAgICAgICBleGNlcHQ6CiAgICAgICAgICAgICAgICBwYXNzCgogICAg' \
                'ICAgIGV4Y2VwdDoKICAgICAgICAgICAgaW1wb3J0IHRyYWNlYmFjawogICAgICAgICAgICB0cmFjZWJhY2sucHJpbnRfZXhjKCkK' \
                'ICAgICAgICAgICAgY29udGludWUKCiAgICByZXR1cm4gKHRvcnJlbnRfc291cmNlcywgaG9zdGVyX3NvdXJjZXMpCg=='

import base64
import json
import os
import shutil
import sys

import requests
import xbmc

from resources.lib.common import tools
from resources.lib.modules import database

if tools.kodiVersion > 17:
    from resources.lib.modules import zfile as zipfile
else:
    import zipfile


class providers:

    def __init__(self):
        self.deploy_init()
        self.pre_update_collection = []
        self.language = 'en'
        self.known_packages = database.get_provider_packages()
        self.known_providers = database.get_providers()

        self.providers_path = os.path.join(tools.dataPath, 'providers')
        self.modules_path = os.path.join(tools.dataPath, 'providerModules')
        self.meta_path = os.path.join(tools.dataPath, 'providerMeta')

        self.update_known_providers()
        self.update_known_packages()

    def poll_database(self):
        self.known_providers = database.get_providers()
        self.known_packages = database.get_provider_packages()

    def update_known_packages(self):
        for root, _, filenames in os.walk(self.meta_path):
            for filename in filenames:
                if filename.endswith('.json'):
                    with open(os.path.join(root, filename)) as file:
                        try:
                            meta = json.loads(file.read())
                            database.add_provider_package(meta['name'], meta['author'], meta['remote_meta'],
                                                          meta['version'])
                        except:
                            pass
        self.poll_database()

    def update_known_providers(self):
        provider_types = ['torrent', 'hosters']
        sys.path.append(tools.dataPath)
        import providers

        all_providers = providers.get_all(self.language)
        all_providers = {'torrent': all_providers[0],
                         'hosters': all_providers[1]}

        for provider_type in provider_types:
            for provider in all_providers[provider_type]:
                if not self._provider_exists(provider[1], provider[2]):
                    database.add_provider(provider[1], provider[2], 'enabled', self.language,
                                          provider_type)

        for known_provider in self.known_providers:
            provider_exists = False
            for provider in all_providers[known_provider['provider_type']]:
                if known_provider['provider_name'] == provider[1] and known_provider['package'] == provider[2]:
                    provider_exists = True
                    break

            if not provider_exists:
                database.remove_individual_provider(known_provider['provider_name'], known_provider['package'])

        self.poll_database()

    def _provider_exists(self, provider_name, package):
        for provider in self.known_providers:
            if provider['provider_name'] == provider_name and provider['package'] == package:
                return True
        return False

    def flip_provider_status(self, package_name, provider_name, status_overide=None):

        current_status = [i for i in database.get_providers()
                          if i['package'] == package_name and i['provider_name'] == provider_name][0]['status']

        if not status_overide:
            if current_status == 'enabled':
                database.adjust_provider_status(provider_name, package_name, 'disabled')
                return 'disabled'
            else:
                database.adjust_provider_status(provider_name, package_name, 'enabled')
                return 'enabled'

        else:
            database.adjust_provider_status(provider_name, package_name, status_overide)
            return status_overide

    def uninstall_package(self, package=None, silent=False):
        import shutil
        packages = [i['pack_name'] for i in self.known_packages]
        if package is None:
            if len(packages) == 0:
                tools.showDialog.ok(tools.addonName, tools.lang(32074))
                return
            selection = tools.showDialog.select("%s: %s %s" %
                                                (tools.addonName, tools.lang(32075), tools.lang(40068)), packages)
            if selection == -1:
                return
            package_name = packages[selection]
            confirm = tools.showDialog.yesno(tools.addonName, tools.lang(32076) + " %s" % package_name)
            if confirm == 0:
                return
        else:
            package_name = package

        try:
            provider_path = os.path.join(self.providers_path, package_name)
            modules_path = os.path.join(self.modules_path, package_name)
            meta_path = os.path.join(self.meta_path, '%s.json' % package_name)
            if os.path.exists(provider_path):
                shutil.rmtree(provider_path)
            if os.path.exists(modules_path):
                shutil.rmtree(modules_path)
            if os.path.exists(meta_path):
                os.remove(meta_path)

            database.remove_package_providers(package_name)
            database.remove_provider_package(package_name)
            import time
            time.sleep(2)
            if not silent:
                tools.showDialog.ok(tools.addonName, '%s ' % package_name + tools.lang(32077))
        except:
            tools.showDialog.ok(tools.addonName,
                                tools.language(40118).enocde('utf-8') % (tools.addonName, package_name))

    def install_package(self, install_style, url=None):
        self.deploy_init()

        if url is None:
            if install_style is None:
                install_style = tools.showDialog.select(tools.addonName, [tools.lang(40302), tools.lang(40303)])
            else:
                install_style = int(install_style)

            if install_style == 0:
                zip_location = tools.fileBrowser(1, tools.lang(40304), 'files', '.zip', True, False)
            elif install_style == 1:
                zip_location = tools.showKeyboard('', '%s: %s' % (tools.addonName, tools.lang(40305)))
                zip_location.doModal()
                if zip_location.isConfirmed() and zip_location.getText() != '':
                    zip_location = zip_location.getText()
                else:
                    return
            else:
                return
        else:
            zip_location = url

        if url is not None:
            zip_file = self.get_zip_file(zip_location, True)
        else:
            zip_file = self.get_zip_file(zip_location, False)

        if zip_file is None:
            return

        self.install_zip(zip_file)

    def install_zip(self, zip_file, silent=False):
        file_list = zip_file.namelist()

        for i in file_list:
            if i.startswith('/') or '..' in i:
                raise Exception

        zip_root_dir = ''
        if file_list[0].endswith('/'):
            zip_root_dir = file_list[0]
            for i, v in enumerate(file_list):
                file_list[i] = file_list[i].replace(zip_root_dir, '')
            file_list = file_list[1:]

        meta_file = None
        for i in file_list:
            if i.startswith('meta.json'):
                meta_file = i
                break

        if meta_file is not None:
            meta = zip_file.open(zip_root_dir + meta_file)
            meta = meta.readlines()
            meta = ''.join(meta)
            meta = meta.replace(' ', '').replace('\r', '').replace('\n', '')
            meta = json.loads(meta)
            requirements = ['author', 'name', 'version']
            for i in requirements:
                if i not in meta:
                    if not silent:
                        self.failed_prompt()
                    tools.log('Source pack is malformed, please check and correct issue in the meta file')
                    return
            author = meta['author']
            version = meta['version']
            pack_name = meta['name']
            remote_meta = meta.get('remote_meta', '')
        else:
            if not silent:
                self.failed_prompt()
            tools.log('Source pack is malformed, please check and correct issue in the meta file')
            import traceback
            traceback.print_exc()
            raise Exception

        if remote_meta == '':
            tools.showDialog.ok(tools.addonName, tools.lang(33016))

        line1 = tools.colorString(tools.lang(33001)) + " %s - v%s" % (pack_name, version)
        line2 = tools.colorString(tools.lang(33002)) + "%s" % author
        line3 = tools.lang(33003)

        if not silent:
            accept = tools.showDialog.yesno(tools.addonName + " - %s" % tools.lang(33004),
                                            line1, line2, line3, tools.lang(33005),
                                            tools.lang(33006))
            if accept == 0:
                return

        self.pre_update_collection = [i for i in database.get_providers() if i['package'] == pack_name]

        folders = ['providerModules/', 'providers/']
        meta_output_location = os.path.join(tools.dataPath, 'providerMeta', '%s.json' % pack_name)

        if os.path.isfile(meta_output_location):
            if os.path.isfile(meta_output_location + '.temp'):
                os.remove(meta_output_location + '.temp')
            try:
                os.rename(meta_output_location, '%s.temp' % meta_output_location)
            except Exception as e:
                self.failure_cleanup(meta_output_location, pack_name, folders)
                tools.log('Failed to create temporary meta file')
                if not silent:
                    tools.showDialog.ok(tools.addonName, tools.lang(33007))
                return

            try:
                self.output_meta(meta)
            except:
                self.failure_cleanup(meta_output_location, pack_name, folders)
                tools.log('Failed to create new meta file')
                if not silent:
                    self.failed_prompt()
                return

        else:
            self.output_meta(meta)

        if not silent:
            install_progress = tools.progressDialog
            install_progress.create(tools.addonName, '%s - %s' % (pack_name, tools.lang(33008)),
                                    tools.lang(33009))
            install_progress.update(-1)
        try:
            for folder in folders:
                try:
                    folder_path = os.path.join(tools.dataPath, folder.strip('/'), pack_name)
                    if os.path.exists(folder_path):
                        if os.path.exists('%s.temp' % folder_path):
                            shutil.rmtree('%s.temp' % folder_path)
                        os.rename(folder_path, '%s.temp' % folder_path)
                    for file in file_list:
                        if file == 'providers/__init__.py':
                            continue
                        if file.startswith(folder):
                            memberpath = os.path.join(zip_root_dir, file)
                            targetpath = os.path.join(tools.dataPath, file)

                            upperdirs = os.path.dirname(targetpath)
                            if upperdirs and not os.path.exists(upperdirs):
                                os.makedirs(upperdirs)

                            if memberpath[-1] == '/':
                                if not os.path.isdir(targetpath):
                                    os.mkdir(targetpath)
                                continue

                            with zip_file.open(memberpath) as source, \
                                    open(targetpath, "wb") as target:
                                shutil.copyfileobj(source, target)

                except:
                    tools.log('Failed to extract to folder - %s' % folder)
                    import traceback
                    traceback.print_exc()
                    self.failure_cleanup(meta_output_location, pack_name, folders)
                    if not silent:
                        self.failed_prompt()
                    return
            try:
                zip_file.close()
            except:
                pass

            if not silent:
                try:
                    install_progress.close()
                except:
                    pass
            if not silent:
                tools.showDialog.ok(tools.addonName, '%s - %s' % (tools.lang(33010), pack_name))
        except:
            import traceback
            traceback.print_exc()
            if not silent:
                try:
                    install_progress.close()
                    tools.showDialog.ok(tools.addonName, '%s - %s' % (tools.lang(33012), pack_name),
                                        tools.lang(33011))
                except:
                    pass
            return

        if os.path.exists('%s.temp' % meta_output_location):
            os.remove('%s.temp' % meta_output_location)
        for folder in folders:
            folder_path = os.path.join(tools.dataPath, folder.strip('/'), pack_name)
            if os.path.exists('%s.temp' % folder_path):
                shutil.rmtree('%s.temp' % folder_path)

        tools.log('Refreshing provider database ')
        database.add_provider_package(pack_name, author, remote_meta, version)

        tools.execute('RunPlugin("plugin://plugin.video.%s/?action=refreshProviders")' % tools.addonName.lower())
        return True

    def failed_prompt(self):
        tools.showDialog.ok(tools.addonName, tools.lang(33013), tools.lang(33011))

    def deploy_init(self):
        folders = ['providerModules/', 'providers/']
        root_init_path = os.path.join(tools.dataPath, '__init__ .py')

        if not os.path.exists(tools.dataPath):
            os.makedirs(tools.dataPath)
        if not os.path.exists(root_init_path):
            open(root_init_path, 'a').close()
        for i in folders:
            folder_path = os.path.join(tools.dataPath, i)
            if not os.path.exists(folder_path):
                os.makedirs(folder_path)
            open(os.path.join(folder_path, '__init__.py'), 'a').close()
        provider_init = open(os.path.join(tools.dataPath, 'providers', '__init__.py'), 'w+')
        try:
            provider_init.write(base64.b64decode(init_contents))
        except:
            provider_init.write(base64.b64decode(init_contents).decode('utf-8'))

    def output_meta(self, meta):
        try:
            output_directory = os.path.join(tools.dataPath, 'providerMeta')
            output_file = os.path.join(tools.dataPath, 'providerMeta', '%s.json' % meta['name'])

            if not os.path.exists(output_directory):
                os.mkdir(output_directory)

            if os.path.exists(output_file):
                os.rename(output_file, '%s.temp' % output_file)

            new_meta_file = open(output_file, 'w+')
            new_meta_file.write(json.dumps(meta))
            new_meta_file.close()
        except Exception as e:
            tools.log('Failed to create new meta file for provider')
            import traceback
            traceback.print_exc()
            raise Exception

    def get_zip_file(self, zip_location, silent=False):
        # This function processes any requests for zip files

        if zip_location == '':
            return

        if zip_location.startswith('special://'):
            zip_location = xbmc.translatePath(zip_location)

        if zip_location.startswith('smb'):
            if not silent:
                tools.showDialog.ok(tools.addonName, tools.lang(33014))
            return

        if zip_location.startswith('http'):
            response = requests.get(zip_location, stream=True)
            if not response.ok and not silent:
                tools.showDialog.ok(tools.addonName, tools.lang(33015))
                return
            else:
                pass
            try:
                import StringIO
                file = zipfile.ZipFile(StringIO.StringIO(response.content))
            except:
                # Python 3 Support
                import io
                file = zipfile.ZipFile(io.BytesIO(response.content))
        else:
            file = zipfile.ZipFile(zip_location)

        return file

    def failure_cleanup(self, meta_loction, package_name, folders):
        # In the event of a failure to install package this function will revert changes made

        tools.log('Reverting changes')
        try:
            if os.path.exists('%s.temp' % meta_loction):
                os.remove(meta_loction)
                os.rename('%s.temp' % meta_loction, meta_loction)
        except:
            pass

        for folder in folders:
            folder_path = os.path.join(tools.dataPath, folder.strip('/'), package_name)
            if os.path.exists('%s.temp' % folder_path):
                try:
                    shutil.rmtree(folder_path)
                except:
                    pass
                os.rename('%s.temp' % folder_path, folder_path)
        pass

    def check_for_updates(self, silent=False, automatic=False):
        # Automatic "True" will update all packages with available updates
        # Silent "True" will prevent kodi from creating any dialogs except for a single notification

        if not silent:
            update_dialog = tools.progressDialog
            update_dialog.create(tools.addonName, tools.lang(33019))
            update_dialog.update(-1)

        updates = []

        packages = self.known_packages

        if len(packages) == 0:
            return

        for package in packages:
            if package['remote_meta'] == '':
                continue

            meta_file = requests.get(package['remote_meta'])
            if meta_file.status_code != 200:
                continue

            meta_file = json.loads(meta_file.text)

            if not meta_file['name'] == package['pack_name']:
                tools.log('Pack name check failure')
                continue
            if not self.check_version_numbers(package['version'], meta_file['version']):
                continue
            if not automatic:
                updates.append(meta_file)
            else:
                self.update(meta_file, silent)

        if not silent:
            try:
                update_dialog.close()
            except:
                pass

        if not automatic:
            return updates

    def update(self, meta_file, silent=False):
        # Hanldes the updating of a package

        update_directory = meta_file['update_directory']
        package_name = meta_file['name']
        version = meta_file['version']
        zip_file = '%s%s-%s.zip' % (update_directory, package_name, version)
        zip_file = self.get_zip_file(zip_file, silent=True)
        if zip_file is None:
            return
        result = self.install_zip(zip_file, silent=silent)
        if result is not None:
            tools.showDialog.notification(tools.addonName, tools.lang(33017) % package_name)

    def check_version_numbers(self, current, new):
        return tools.check_version_numbers(current, new)

    def manual_update(self):
        update = self.check_for_updates()

        # If there are no available updates return
        if len(update) == 0:
            tools.showDialog.ok(tools.addonName, tools.lang(33018))
            return

        # Display available packages to update
        display_list = ['%s - %s' % (i['name'], i['version']) for i in update]
        selection = tools.showDialog.select(tools.addonName, display_list)

        if selection == -1:
            return

        selection = update[selection]

        self.update(selection)
