# -*- coding: utf-8 -*-
'''
Created on 30/04/2011

@author: shai
'''

import re,xbmcplugin,sys,xbmc,json,random,xbmcgui
import wallacommon as common

__BASE_URL__ = 'http://nickjr.walla.co.il/'
__NAME__ = 'nickjr'

class manager_nickjr:
    def __init__(self):
        self.MODES = common.enum(GET_SERIES_LIST=1, GET_EPISODES_LIST=2, PLAY_MODE=3)
        
    def work(self, mode, url='', name='', page=''):
        
        if (mode==self.MODES.GET_SERIES_LIST):
            self.getSeriesList()
        elif(mode==self.MODES.GET_EPISODES_LIST):
            self.getEpisodeList(url)
        elif(mode==self.MODES.PLAY_MODE):
            self.getLink(url)

    def getSeriesList(self):
		contentType,block = common.getMatches(__BASE_URL__+'tvshows','desktop&quot;:5(.*?)</section>')
		page = re.compile('<a href="/(.*?)".*?<img src="(.*?)".*?cd-title>(.*?)<').findall(block[0])
		for path in page:
			summary = ''
			iconImage='http:' + path[1]
			url=__BASE_URL__ + path[0]
			title=path[2]
			common.addDir('utf-8',title, url, self.MODES.GET_EPISODES_LIST, iconImage, __NAME__, summary)               
		xbmcplugin.setContent(int(sys.argv[1]), 'tvshows')

    def getEpisodeList(self, inUrl):
		if 'tvshow' in inUrl:
			contentType,block = common.getMatches(inUrl, '<nav class="common-sub-menu">(.*?)</nav>')
			matches = re.compile('<li class=""><a href="/item/(\d*)">(.*?)</a>').findall(block[0])
			seasons = []
			for match in matches:
				if 'פרקים מלאים' in match[1] or 'משפחת יומולדת' in match[1]:
					seasons.append(match)
			sl = len(seasons)
			if sl < 1:
				return
			elif sl == 1:
				inUrl=__BASE_URL__+'item/'+seasons[0][0]
			else:
				for season in seasons:
					common.addDir('UTF-8', season[1], __BASE_URL__+'item/'+season[0], self.MODES.GET_EPISODES_LIST, 'DefaultFolder.png', __NAME__)
				xbmcplugin.setContent(int(sys.argv[1]), 'tvshows')
				return
				
		contentType,mainPage = common.getData(inUrl)
		episodes = re.compile('/TVEpisode.*?href="(.*?)".*?:&quot;(.*?)&quot;.*?src="(.*?)".*?title>(.*?)</span>').findall(mainPage)
		for url, description, image, title in episodes:
			url = '{0}{1}'.format(__BASE_URL__[:-1], url)
			iconImage = 'http:{0}'.format(image)
			common.addVideoLink("utf-8",title, url ,self.MODES.PLAY_MODE, iconImage, elementId=__NAME__)
			
		nav = re.compile('class="pager"(.*?)</nav>').findall(mainPage)
		if len(nav) > 0:
			pages = re.compile('href="(.*?)" class="(.*?)"').findall(nav[0])
			if len(pages) > 0 and pages[-1][1] == 'icon-right':
				common.addDir('UTF-8', common.__language__(30001), __BASE_URL__ + pages[-1][0][1:], self.MODES.GET_EPISODES_LIST, 'DefaultFolder.png', __NAME__)
		xbmcplugin.setContent(int(sys.argv[1]), 'episodes')

    def getLink(self, inUrl):
		servers = ['62.90.90.37', '31.168.228.117', '82.80.192.28', '31.168.228.126', '82.80.192.2', '31.168.228.113']
		contentType,mainPage = common.getData(inUrl)
		match = re.compile("data-player='(.*?)' data-adscontrol").findall(mainPage)
		result = json.loads(match[0])
		if result['vimmeId'] is None:
			id = result['id'][:-2].zfill(5)
			link = 'http://{0}/walla_vod/_definst_/mp4:media/0{1}/{2}/{3}-40.mp4/playlist.m3u8'.format(random.choice(servers), id[:2], id[2:], result['id'])
		else:
			link = 'http://{0}/walla_vod/_definst_/amlst:{1}.High.smil/playlist.m3u8'.format(random.choice(servers), result['vimmeId'])
		liz = xbmcgui.ListItem(path=link)
		xbmcplugin.setResolvedUrl(handle=int(sys.argv[1]), succeeded=True, listitem=liz)