# -*- coding: utf-8 -*-

'''
Created on 30/04/2011

@author: shai
'''
from __future__ import print_function
from future import standard_library
standard_library.install_aliases()
from builtins import str
from builtins import range
__USERAGENT__ = 'Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.11 (KHTML, like Gecko) Chrome/23.0.1271.97 Safari/537.11'

import urllib.request, urllib.parse, urllib.error, re, xbmc, xbmcplugin, xbmcgui, xbmcaddon, os, sys, time, xbmcaddon

__settings__ = xbmcaddon.Addon(id='plugin.video.wallaNew.video')
__language__ = __settings__.getLocalizedString
__PLUGIN_PATH__ = __settings__.getAddonInfo('path')
__DEBUG__ = __settings__.getSetting("DEBUG") == "true"
__addon__ = xbmcaddon.Addon()
__addonname__ = __addon__.getAddonInfo('name')
__icon__ = __addon__.getAddonInfo('icon')
sys.modules["__main__"].dbg = True


def enum(**enums):
        return type('Enum', (), enums)

def getMatches(url, pattern):
        contentType, page = getData(url)
        matches = re.compile(pattern).findall(page)
        return contentType, matches   

def getParams(arg):
        param = []
        paramstring = arg
        if len(paramstring) >= 2:
            params = arg
            cleanedparams = params.replace('?', '')
            if (params[len(params) - 1] == '/'):
                params = params[0:len(params) - 2]
            pairsofparams = cleanedparams.split('&')
            param = {}
            for i in range(len(pairsofparams)):
                splitparams = {}
                splitparams = pairsofparams[i].split('=')
                if (len(splitparams)) == 2:    
                    param[splitparams[0]] = splitparams[1]
                                
        return param

def translate(arg):
        return __language__(arg)
        
def addDir(contentType, name, url, mode, iconimage='DefaultFolder.png', elementId='', summary='', fanart='',isRealFolder=True):
        try:
           
            u = sys.argv[0] + "?url=" + urllib.parse.quote_plus(url) + "&mode=" + str(mode) + "&name=" + name + "&module=" + urllib.parse.quote_plus(elementId)
            #liz = xbmcgui.ListItem(clean(contentType, name), iconImage=iconimage, thumbnailImage=iconimage)
            liz=xbmcgui.ListItem(clean(contentType, name))
            liz.setArt({'thumb' : iconimage, 'fanart': iconimage, 'icon': iconimage})
            liz.setInfo(type="Video", infoLabels={ "Title": urllib.parse.unquote(clean(contentType, name)), "Plot": urllib.parse.unquote(summary)})
            if not fanart == '':
                liz.setProperty("Fanart_Image", fanart)
               
            ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=u, listitem=liz, isFolder=isRealFolder)
            if __DEBUG__:
                 
                print("added directory success:" + clean(contentType, name) + " url=" + clean('utf-8',u))
            return ok
        except Exception as e:
            print("WALLA exception in addDir")
            print(e)
            raise
        

def addLink(contentType, name, url, iconimage='DefaultFolder.png', time='', sub=''):
        liz = xbmcgui.ListItem(clean(contentType, name), iconImage="DefaultVideo.png", thumbnailImage=iconimage)
        liz.setInfo(type="Video", infoLabels={ "Title": urllib.parse.unquote(clean(contentType, name)), "Duration":time, "Plot": urllib.parse.unquote(sub)})
        ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=url, listitem=liz)
        return ok

def addVideoLink(contentType, name, url, mode, iconimage='DefaultFolder.png', elementId='', sum='',duration='0', year=None):
        u = sys.argv[0] + "?url=" + urllib.parse.quote_plus(str(url)) + "&mode=" + str(mode) + "&name=" + name + "&module=" + urllib.parse.quote_plus(elementId)
        #liz = xbmcgui.ListItem(clean(contentType, name), iconImage=iconimage, thumbnailImage=iconimage)
        liz=xbmcgui.ListItem(clean(contentType, name))
        liz.setArt({'thumb' : iconimage, 'fanart': iconimage, 'icon': iconimage})
        liz.setInfo(type="Video", infoLabels={ "Title": urllib.parse.unquote(clean(contentType, name)),"Duration":str(duration), "Plot": urllib.parse.unquote(sum), "Year": year, "Aired": '{0}-01-01'.format(year)})
        liz.setProperty('IsPlayable', 'true')
        ok = xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=u, listitem=liz, isFolder=False)
        return ok
    
def getData(url):
        #print url
        if __DEBUG__:
            print('url --> ' + url)
          
        try:
            req = urllib.request.Request(url)
            req.add_header('User-Agent', __USERAGENT__)
            response = urllib.request.urlopen(req)
            contentType = response.headers['content-type']
            if __DEBUG__:
                print("WALLA got content type " + contentType)
            data = response.read().decode('utf-8').replace("\n", "").replace("\t", "").replace("\r", "")
            response.close()            
            
        except:
            errno, errstr = sys.exc_info()[:2]
            
            xbmc.log('Error in getData: ' + str(errno) + ': ' + str(errstr), xbmc.LOGERROR)
            return 'UTF-8', 'unavailable'
        return contentType, data

def getImageNick(url):
            contentType,page = getData(url)
            titleMatches = re.compile('class="stripe_title w7b white">\s*(.*?)\s*</h1>\s*<img src="(.*?)"').findall(page)
            if len(titleMatches) == 0:
                # try a different possibility
                titleMatches = re.compile('class="stripe_title w7b white">.*?>(.*?)<.*?src="(.*?)"').findall(page)
            if titleMatches:
                    #urllib.urlretrieve(titleMatches[0][1], cachePath)
                   return titleMatches[0][1]
            return ''

        
def getImage(imageURL, siteName):
        imageName = getImageName(imageURL)
        cacheDir = xbmc.translatePath(os.path.join(__PLUGIN_PATH__, 'cache', 'images', siteName))
        cachePath = xbmc.translatePath(os.path.join(cacheDir, imageName))
        if not os.path.exists(cachePath):
            # # fetch the image and store it in the cache path
            if not os.path.exists(cacheDir):
                os.makedirs(cacheDir)
            urllib.request.urlretrieve(imageURL, cachePath)
        return cachePath
        
def getImageName(imageURL):
        idx = int(imageURL.rfind("/")) + 1
        return imageURL[idx:]

def getCookie(url, cookiename):
        req = urllib.request.Request(url)
        req.add_header('User-Agent', __USERAGENT__)
        response = urllib.request.urlopen(req)
        for header in response.headers:
            name = response.headers[header]
            if __DEBUG__:
                print('Cookie --> %s' % (name))
        data = response.read().replace("\n", "").replace("\t", "").replace("\r", "")        
        response.close()
        return data, "ERROR"

def convertToUTF(name):
    return clean('utf-8',name)

def clean(contentType, name):
        
    try:
         
        if isinstance(name, str):
         
            if contentType.lower().find('utf-8') == -1: 
            
                name = name.decode('windows-1255', 'replace')
                name = name.encode('utf-8')
        elif isinstance(name, str):
            name = name.encode('utf-8')    
 
    except Exception as e:
         print('Error in clean: ')
         print(e)
         raise e
#     if (name):
#         cleanName = name.replace("&quot;", "\"").replace("&#39;", "'").replace("&nbsp;", " ")
#         return  cleanName
    return name 


