import xbmc, xbmcaddon, xbmcgui ,os, json, requests ,gzip, shutil
from resources.lib.modules import control

def SetPVRSetting(PVRFolder):
	try:
		os.makedirs(os.path.join(PVRFolder))
	except:	pass
	
	if control.addon().getSetting('pvrlite')=="true":
		xmltvGzFile = "lite.xml.gz"
	else:
		xmltvGzFile = "full.xml.gz"	
		
	PVRSetting = {	"epgUrl": "%sepg/%s/%s/%s"%(control.addon().getSetting('api'),control.addon().getSetting('email'),control.addon().getSetting('password'),xmltvGzFile),
					"epgPathType":"1",
					"logoBaseUrl":"https://raw.githubusercontent.com/Apollo2000/TVLogos/raw/master/",
					"logoPathType":"1",
					"m3uUrl": "%slist/%s/%s/m3u8/livetv"%(control.addon().getSetting('api'),control.addon().getSetting('email'),control.addon().getSetting('password')),
					"m3uPathType":"1"}
	settingFile = xbmc.translatePath(os.path.join(PVRFolder, 'settings.xml'))
	xml = []
	xml.append("<settings>\n")
	for k, v in PVRSetting.iteritems():
		xml.append('\t<setting id="{0}" value="{1}" />\n'.format(k, v))
	xml.append("</settings>\n")
	outF = open(settingFile, 'wb')
	outF.write("".join(xml))
	outF.close()

def GetPVRAddon():
	PVRAddon = None
	if xbmc.getCondVisibility("System.HasAddon(pvr.iptvsimple)"):
		try:
			PVRAddon = xbmcaddon.Addon("pvr.iptvsimple")
		except:	pass
	return PVRAddon

def SetFirstPVR():
	i = control.dialog.yesno(control.addon().getAddonInfo('name'),"Use TV Guide ?")
	if i == 0:
		control.addon().setSetting('pvr', "false")
	else:
		control.addon().setSetting('pvr', "true")

def runPVR():
	enable_iptvsimple  = '{"jsonrpc":"2.0","method":"Addons.SetAddonEnabled","params":{"addonid":"pvr.iptvsimple","enabled":true},"id":1}'
	enable_pvrmanager  = '{"jsonrpc":"2.0", "method":"Settings.SetSettingValue", "params":{"setting":"pvrmanager.enabled", "value":true},"id":1}'

	if control.addon().getSetting('firstPVR')=="true":
		SetFirstPVR()

	if control.addon().getSetting('pvr')=="false":
		return

	PVRFolder = xbmc.translatePath(os.path.join('special://profile', 'addon_data', 'pvr.iptvsimple'))
	PVRAddon = GetPVRAddon()

	SetPVRSetting(PVRFolder)

	xbmc.executebuiltin('Notification('+control.addon().getAddonInfo('name')+',"Please wait, loading TV Guide.", 5000,{0})'.format(os.path.join(control.addonPath ,"icon.png")))

	xbmc.executeJSONRPC(enable_iptvsimple)
	xbmc.executeJSONRPC(enable_pvrmanager)
	xbmc.sleep(5)
	xbmc.executebuiltin('StopPVRManager')
	xbmc.executebuiltin('StartPVRManager')

	if control.addon().getSetting('firstPVR')=="true":
		control.addon().setSetting('firstPVR', "false")
		control.dialog.ok(control.addon().getAddonInfo('name'),"Please restart kodi for TV Guide to start")