# -*- coding: utf-8 -*-
from requests import get
from resources.lib.modules import control
import sys,re,json,urllib,urlparse,datetime,xbmc,xbmcgui

class channels:
	def __init__(self):
		self.list = []
		self.headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'X-API-VERSION': 'v2', 'Authorization': 'Bearer '+control.addon().getSetting('token')}

	def search(self):
		try:
			control.idle()

			t = control.lang(32010).encode('utf-8')
			k = control.keyboard('', t) ; k.doModal()
			q = k.getText() if k.isConfirmed() else None

			if (q == None or q == ''): return

			response = get(control.myaddon_link+'info/livetv/search/%s'%q, headers=self.headers)
			data = json.loads(response.text)
			if "data" not in data:
				from resources.lib.modules import myaddon
				myaddon.myAddon().login(1)
				return 0
			self.livetvItems(data['data'])
		except:
			return

	def livetvItems(self,channels):
		for channel in channels:
			try:
				if "channels" in channel:
					hd = channel["channels"][0]["hd"]
			except: hd = 0
			
			try: title = channel['now']["now"]["title"].encode('utf-8')
			except: title = ''
			if title == None: title = ''

			try: desc = channel['now']["now"]["desc"].encode('utf-8')
			except: desc = ''
			if desc == None: desc = ''
			try: 
				self.list.append({'id': str(channel['id']),'title':title,'desc':desc,'name': str(channel['name'].encode('utf-8')),'hd': hd, 'url': control.myaddon_link+'stream/%s/%s/livetv.epg/%s.m3u8'%(control.addon().getSetting('email'),control.addon().getSetting('password'),channel['id']),'poster': 'https://raw.githubusercontent.com/Apollo2000/TVLogos/master/'+str(channel['id'])+'.png'})
			except:
				print "####### ERROR Getting List from Server: %s %s"%(str(channel['id']),channel)
				pass
	
		try: self.list = sorted(self.list, key=lambda k: k['name'])
		except: pass		

		self.channelDirectory(self.list)
		return self.list
		
	def channelsCategory(self, category_id):
		try:
			response = get(control.myaddon_link+'info/livetv/categories/%s'%category_id, headers=self.headers)
			data = json.loads(response.text)
			if "data" not in data:
				control.infoDialog(data['error'], icon='WARNING',time=20000)
				print "**** MyAddon ERROR: {0}".format(data['massage'])
				return 0
			self.livetvItems(data['data'])
		except:
			pass

	def channelDirectory(self, items):
		if items == None or len(items) == 0: control.idle() ; sys.exit()

		sysaddon = sys.argv[0]
		syshandle = int(sys.argv[1])
		addonPoster, addonBanner = control.addonPoster(), control.addonBanner()
		addonFanart = control.addonFanart()

		response = get(control.myaddon_link+'favorite/livetv/', headers=self.headers)
		favoriteJson = json.loads(response.text)
		favoriteArray = {}
		
		if "data" in favoriteJson:
			if favoriteJson["data"] is not None:
				for fav in favoriteJson["data"]:
					favoriteArray[fav] = 1

		for i in items:
			try:
				label = '[B]%s[/B] %s' % (i['name'].upper(),i['title'])
				poster = i['poster']
				banner = '0'
				id = i['id']

				item = control.item(label=label)
				if (str(i['hd'])=="1"):
					item.addStreamInfo('video', { 'width':1280 ,'height' : 720 })
				elif (str(i['hd'])=="2"):
					item.addStreamInfo('video', { 'width':1920 ,'height' : 1080 })
				else:
					item.addStreamInfo('video', { 'width':600 ,'height' : 320 })

				item.setArt({'icon': poster, 'thumb': poster, 'poster': poster, 'banner': banner})

				contextMenuItems = []
				if id in favoriteArray:
					contextMenuItems.append(('Remove from My List', 'XBMC.RunPlugin(%s?action=liveMyList&param=0&epg_id=%s)' % (sysaddon,id)))
				else:
					contextMenuItems.append(('Add to My List', 'XBMC.RunPlugin(%s?action=liveMyList&param=1&epg_id=%s)' % (sysaddon,id)))
				item.addContextMenuItems(contextMenuItems, replaceItems=True)
				
				item.setInfo(type='Video', infoLabels = {"Title": '{0}'.format(label), "Plot": '{0}'.format(i['desc'])})
				control.addItem(handle=syshandle, url=i['url'], listitem=item, isFolder=False)
			except:
				pass

		control.content(syshandle, 'movies')
		#control.do_block_check(False)
		control.directory(syshandle, cacheToDisc=True)

	def channelsMyList(self):
		response = get(control.myaddon_link+'favorite/livetv/', headers=self.headers)
		favoriteJson = json.loads(response.text)
		favoriteArray = []
		
		if "data" in favoriteJson:
			if favoriteJson["data"] is not None:
				for fav in favoriteJson["data"]:
					response = get(control.myaddon_link+'info/livetv/epg/%s/'%fav, headers=self.headers)
					info = json.loads(response.text)
					if "data" in info:
						favoriteArray.append(info["data"][0])
				
		self.livetvItems(favoriteArray)
