# -*- coding: utf-8 -*-
from requests import get
from resources.lib.modules import control
import sys,re,json,urllib,urlparse

class tvshows:
	def __init__(self):
		self.list = []
		self.headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'X-API-VERSION': 'v3', 'Authorization': 'Bearer '+control.addon().getSetting('token')}
	
	def search(self):
		try:
			control.idle()

			t = control.lang(32010).encode('utf-8')
			k = control.keyboard('', t) ; k.doModal()
			q = k.getText() if k.isConfirmed() else None

			if (q == None or q == ''): return

			response = get(control.myaddon_link+'info/tvshow/search/%s'%q, headers=self.headers)
			data = json.loads(response.text)
			if "data" not in data:
				from resources.lib.modules import myaddon
				myaddon.myAddon().login(1)
				return 0
			self.tvshowItems(data['data'])
		except:
			return
	
	def tvshowItems(self,tvshows):
		userLang = control.apiLanguage(control.lang)["id"]
		for tvshow in tvshows:
			meta = tvshow["meta"]
			
			try:
				imdb = tvshow['imdb_id']
				tvdb = tvshow['tvdb_id']
				
				title = tvshow['title']

				if 'plot' in meta:
					plot = meta['plot']
				else:
					plot = 0
				
				if userLang!="en":
					try:
						langData = control.getLangMeta("tv", imdb, tvdb, userLang)
						if "name" in langData:
							title = langData['name']
						if "overview" in langData:
							plot = langData['overview']
					except:
						pass

				title = title.encode('utf-8')
				plot = plot.encode('utf-8')

				year = tvshow['year']

				if 'poster' in meta:
					poster = meta['poster']
				else:
					poster = 0

				if 'fanart' in meta:
					fanart = meta['fanart']
				else:
					fanart = 0

				if 'released' in meta:
					premiered = meta['released'][0:10]
				else:
					premiered = '0'
				
				if 'genres' in meta:
					genre = meta['genres']
				else:
					genre = 0
				genre = genre.encode('utf-8')
				
				if 'rank' in meta:
					rating = meta['rank']
				else:
					rating = 0

				if 'votes' in meta:
					votes = meta['votes']
				else:
					votes = 0

				if 'director' in meta:
					director = meta['director']
				else:
					director = 0
				director = director.replace(', ', ' / ')
				director = director.encode('utf-8')
				
				if 'writer' in meta:
					writer = meta['writer']
				else:
					writer = 0
				writer = writer.replace(', ', ' / ')
				writer = writer.encode('utf-8')
				
				self.list.append({'imdb': imdb,'title': title, 'year': year, 'code': imdb, 'tvdb': tvdb, 'poster': poster, 'banner': '', 'fanart': fanart, 'premiered': premiered, 'studio': '', 'genre': genre, 'rating': rating, 'votes': votes, 'director': director, 'writer': writer, 'plot': plot})
			except: 
				print "####### ERROR JSON Rec: {0}".format(tvshow)
				pass
	
		self.tvshowDirectory(self.list)
		return self.list
	
	def tvshowsYear(self, param):
		param = int(param)
		try:
			response = get(control.myaddon_link+'info/tvshows/year/%d/0/300'%param, headers=self.headers)
			data = json.loads(response.text)
			if "data" not in data:
				print "### ERROR Load Tvshows Category JSON: {0}".format(param)
				return
			
			self.tvshowItems(data['data'])
		except:
			return []
			pass
			
	def tvshowsCategory(self, category_id, page=0):
		try:
			response = get(control.myaddon_link+'info/tvshows/items/%s/%s/100'%(category_id,page), headers=self.headers)
			data = json.loads(response.text)
			if "data" not in data:
				print "### ERROR Load TV Shows Category JSON: {0}".format(category_id)
				return
			print "### ERROR Load TV Shows Category JSON: {0}".format(data['data'])
			self.tvshowItems(data['data']["infos"])
		except:
			return []
			pass

	def tvshowDirectory(self, items):
		if items == None or len(items) == 0: control.idle() ; sys.exit()

		sysaddon = sys.argv[0]
		syshandle = int(sys.argv[1])
		addonPoster, addonBanner = control.addonPoster(), control.addonBanner()
		addonFanart, settingFanart = control.addonFanart(), control.setting('fanart')

		response = get(control.myaddon_link+'favorite/tvshow/', headers=self.headers)
		favoriteJson = json.loads(response.text)
		favoriteArray = {}
		
		if "data" in favoriteJson:
			if favoriteJson["data"] is not None:
				for fav in favoriteJson["data"]:
					favoriteArray[fav] = 1
					
		for i in items:
			try:
				label = i['title']
				systitle = sysname = urllib.quote_plus(i['title'])
				sysimage = urllib.quote_plus(i['poster'])
				imdb, tvdb, year = i['imdb'], i['tvdb'], i['year']

				meta = dict((k,v) for k, v in i.iteritems() if not v == '0')
				meta.update({'mediatype': 'tvshow'})
				meta.update({'trailer': '%s?action=trailer&name=%s' % (sysaddon, sysname)})
				if not 'duration' in i: meta.update({'duration': '60'})
				elif i['duration'] == '0': meta.update({'duration': '60'})
				try: meta.update({'duration': str(int(meta['duration']) * 60)})
				except: pass
				try: meta.update({'genre': cleangenre.lang(meta['genre'], self.lang)})
				except: pass

				item = control.item(label=label)

				art = {}

				if 'poster' in i and not i['poster'] == '0':
					art.update({'icon': i['poster'], 'thumb': i['poster'], 'poster': i['poster']})
				else:
					art.update({'icon': addonPoster, 'thumb': addonPoster, 'poster': addonPoster})

				if 'banner' in i and not i['banner'] == '0':
					art.update({'banner': i['banner']})
				elif 'fanart' in i and not i['fanart'] == '0':
					art.update({'banner': i['fanart']})
				else:
					art.update({'banner': addonBanner})

				if 'clearlogo' in i and not i['clearlogo'] == '0':
					art.update({'clearlogo': i['clearlogo']})

				if 'clearart' in i and not i['clearart'] == '0':
					art.update({'clearart': i['clearart']})

				if settingFanart == 'true' and 'fanart' in i and not i['fanart'] == '0':
					item.setProperty('Fanart_Image', i['fanart'])
				elif not addonFanart == None:
					item.setProperty('Fanart_Image', addonFanart)

				if "fanart" in meta:    del (meta["fanart"]);
				if "banner" in meta:    del (meta["banner"]);
				if "imdb" in meta:      del (meta["imdb"]);
				if "poster" in meta:    del (meta["poster"]);
				if "tvdb" in meta:      del (meta["tvdb"]);
                
				contextMenuItems = []
				
				if imdb in favoriteArray:
					contextMenuItems.append(('Remove from My List', 'XBMC.RunPlugin(%s?action=tvMyList&param=0&imdb=%s)' % (sysaddon,imdb)))
				else:
					contextMenuItems.append(('Add to My List', 'XBMC.RunPlugin(%s?action=tvMyList&param=1&imdb=%s)' % (sysaddon,imdb)))
				
				item.setArt(art)
				item.addContextMenuItems(contextMenuItems, replaceItems=True)
				item.setInfo(type='Video', infoLabels = meta)

				url = '%s?action=tvshowsSeasons&imdb=%s&title=%s' % (sysaddon, imdb, systitle)

				control.addItem(handle=syshandle, url=url, listitem=item, isFolder=True)
			except:
				pass

		control.content(syshandle, 'tvshows')
		control.directory(syshandle, cacheToDisc=True)

	def tvshowsMyList(self):
		response = get(control.myaddon_link+'favorite/tvshow/', headers=self.headers)
		favoriteJson = json.loads(response.text)
		favoriteArray = []
		
		if "data" in favoriteJson:
			if favoriteJson["data"] is not None:
				for fav in favoriteJson["data"]:
					response = get(control.myaddon_link+'info/tvshows/%s/'%fav, headers=self.headers)
					info = json.loads(response.text)
					if "data" in info:
						favoriteArray.append(info["data"][0])
		favoriteArray.sort(key=lambda x: [x['title']])
		self.tvshowItems(favoriteArray)