# -*- coding: utf-8 -*-
import urlparse,os,sys,json,requests,time
import xbmc,xbmcaddon,xbmcplugin,xbmcgui,xbmcvfs
import xml.etree.ElementTree as ET 

addon = xbmcaddon.Addon
addonInfo = xbmcaddon.Addon().getAddonInfo
lang = xbmcaddon.Addon().getLocalizedString
lang2 = xbmc.getLocalizedString
infoLabel = xbmc.getInfoLabel
dataPath = xbmc.translatePath(addonInfo('profile')).decode('utf-8')
dialog = xbmcgui.Dialog()
addonPath = xbmc.translatePath(addonInfo('path'))
setting = xbmcaddon.Addon().getSetting
setSetting = xbmcaddon.Addon().setSetting
myaddon_link = addon().getSetting('api').lower()
condVisibility = xbmc.getCondVisibility
item = xbmcgui.ListItem
addItem = xbmcplugin.addDirectoryItem
content = xbmcplugin.setContent
property = xbmcplugin.setProperty
directory = xbmcplugin.endOfDirectory
resolve = xbmcplugin.setResolvedUrl
jsonrpc = xbmc.executeJSONRPC
execute = xbmc.executebuiltin
keyboard = xbmc.Keyboard

def artPath():
	if condVisibility('System.HasAddon(script.myaddon.artwork)'):
		return os.path.join(xbmcaddon.Addon('script.myaddon.artwork').getAddonInfo('path'), 'resources', 'media', 'collusion')

def addonIcon():
	return os.path.join(addonPath, 'icon.png')

def addonThumb():
	return os.path.join(addonPath, 'poster.png')

def addonPoster():
	return os.path.join(addonPath, 'poster.png')

def addonBanner():
	return os.path.join(addonPath, 'banner.png')

def addonFanart():
	return os.path.join(addonPath, 'fanart.jpg')

def artwork():
	execute('RunPlugin(plugin://script.myaddon.artwork)')

def infoDialog(message, heading=addonInfo('name'), icon='', time=3000, sound=False):
	if icon == '': icon = addonIcon()
	elif icon == 'INFO': icon = xbmcgui.NOTIFICATION_INFO
	elif icon == 'WARNING': icon = xbmcgui.NOTIFICATION_WARNING
	elif icon == 'ERROR': icon = xbmcgui.NOTIFICATION_ERROR
	dialog.notification(heading, message, icon, time, sound=sound)


def yesnoDialog(line1, line2, line3, heading=addonInfo('name'), nolabel='', yeslabel=''):
	return dialog.yesno(heading, line1, line2, line3, nolabel, yeslabel)


def selectDialog(list, heading=addonInfo('name')):
	return dialog.select(heading, list)

def metaFile():
	if condVisibility('System.HasAddon(script.myaddon.metadata)'):
		return os.path.join(xbmcaddon.Addon('script.myaddon.metadata').getAddonInfo('path'), 'resources', 'data', 'meta.db')


def apiLanguage(ret_name=None):
	langDict = {'Bulgarian': 'bg', 'Chinese': 'zh', 'Croatian': 'hr', 'Czech': 'cs', 'Danish': 'da', 'Dutch': 'nl', 'English': 'en', 'Finnish': 'fi', 'French': 'fr', 'German': 'de', 'Greek': 'el', 'Hebrew': 'he', 'Hungarian': 'hu', 'Italian': 'it', 'Japanese': 'ja', 'Korean': 'ko', 'Norwegian': 'no', 'Polish': 'pl', 'Portuguese': 'pt', 'Romanian': 'ro', 'Russian': 'ru', 'Serbian': 'sr', 'Slovak': 'sk', 'Slovenian': 'sl', 'Spanish': 'es', 'Swedish': 'sv', 'Thai': 'th', 'Turkish': 'tr', 'Ukrainian': 'uk'}

	trakt = ['bg','cs','da','de','el','en','es','fi','fr','he','hr','hu','it','ja','ko','nl','no','pl','pt','ro','ru','sk','sl','sr','sv','th','tr','uk','zh']
	tvdb = ['en','sv','no','da','fi','nl','de','it','es','fr','pl','hu','el','tr','ru','he','ja','pt','zh','cs','sl','hr','ko']
	youtube = ['gv', 'gu', 'gd', 'ga', 'gn', 'gl', 'ty', 'tw', 'tt', 'tr', 'ts', 'tn', 'to', 'tl', 'tk', 'th', 'ti', 'tg', 'te', 'ta', 'de', 'da', 'dz', 'dv', 'qu', 'zh', 'za', 'zu', 'wa', 'wo', 'jv', 'ja', 'ch', 'co', 'ca', 'ce', 'cy', 'cs', 'cr', 'cv', 'cu', 'ps', 'pt', 'pa', 'pi', 'pl', 'mg', 'ml', 'mn', 'mi', 'mh', 'mk', 'mt', 'ms', 'mr', 'my', 've', 'vi', 'is', 'iu', 'it', 'vo', 'ii', 'ik', 'io', 'ia', 'ie', 'id', 'ig', 'fr', 'fy', 'fa', 'ff', 'fi', 'fj', 'fo', 'ss', 'sr', 'sq', 'sw', 'sv', 'su', 'st', 'sk', 'si', 'so', 'sn', 'sm', 'sl', 'sc', 'sa', 'sg', 'se', 'sd', 'lg', 'lb', 'la', 'ln', 'lo', 'li', 'lv', 'lt', 'lu', 'yi', 'yo', 'el', 'eo', 'en', 'ee', 'eu', 'et', 'es', 'ru', 'rw', 'rm', 'rn', 'ro', 'be', 'bg', 'ba', 'bm', 'bn', 'bo', 'bh', 'bi', 'br', 'bs', 'om', 'oj', 'oc', 'os', 'or', 'xh', 'hz', 'hy', 'hr', 'ht', 'hu', 'hi', 'ho', 'ha', 'he', 'uz', 'ur', 'uk', 'ug', 'aa', 'ab', 'ae', 'af', 'ak', 'am', 'an', 'as', 'ar', 'av', 'ay', 'az', 'nl', 'nn', 'no', 'na', 'nb', 'nd', 'ne', 'ng', 'ny', 'nr', 'nv', 'ka', 'kg', 'kk', 'kj', 'ki', 'ko', 'kn', 'km', 'kl', 'ks', 'kr', 'kw', 'kv', 'ku', 'ky']

	name = None
	name = setting('api.language')
	if not name: name = 'AUTO'
	
	if name[-1].isupper():
		try: name = xbmc.getLanguage(xbmc.ENGLISH_NAME).split(' ')[0]
		except: pass
	try: name = langDict[name]
	except: name = 'en'
	lang = {'trakt': name} if name in trakt else {'trakt': 'en'}
	lang['tvdb'] = name if name in tvdb else 'en'
	lang['youtube'] = name if name in youtube else 'en'
	lang['id'] = name
	
	if ret_name:
		lang['trakt'] = [i[0] for i in langDict.iteritems() if i[1] == lang['trakt']][0]
		lang['tvdb'] = [i[0] for i in langDict.iteritems() if i[1] == lang['tvdb']][0]
		lang['youtube'] = [i[0] for i in langDict.iteritems() if i[1] == lang['youtube']][0]

	return lang

def refresh():
	return execute('Container.Refresh')
	
def getLangMeta(type, imdb, tvdb, lang):
	filename = '%s.%s.%s.json' % (type,imdb, lang)
	jsonfile = caching(filename, "https://api.themoviedb.org/3/find/%s?api_key=6a5be4999abf74eba1f9a8311294c267&external_source=imdb_id&language=%s"%(imdb,lang))
	
	with open(jsonfile) as json_file:
		data = json.load(json_file)
	if type=="movie" and "movie_results" in data:
		return data["movie_results"][0]
	if type=="tv" and "tv_results" in data:
		return data["tv_results"][0]
	return

def caching(filename, url):
	cachefolder = xbmc.translatePath(os.path.join(addonInfo('profile'), 'cachemeta')).encode('utf-8')
	if not os.path.exists(cachefolder):
		xbmcvfs.mkdirs(cachefolder)
	
	file = os.path.join(cachefolder, filename)
	if not os.path.exists(file) or (time.time()-os.path.getmtime(file) > 14*24*60*60):
		r = requests.get(url)  
		with open(file, 'wb') as f:
			f.write(r.content)
	
	return file

def openSettings(query=None, id=addonInfo('id')):
	try:
		idle()
		execute('Addon.OpenSettings(%s)' % id)
		if query == None: raise Exception()
		c, f = query.split('.')
		execute('SetFocus(%i)' % (int(c) + 100))
		execute('SetFocus(%i)' % (int(f) + 200))
	except:
		return	
		
def idle():
	return execute('Dialog.Close(busydialog)')
