# -*- coding: utf-8 -*-
from requests import get
from resources.lib.modules import control
import sys,re,json,urllib,urlparse,xbmcgui

class movies:
	def __init__(self):
		self.list = []
		self.headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'X-API-VERSION': 'v2', 'Authorization': 'Bearer '+control.addon().getSetting('token')}

	def search(self):
		try:
			control.idle()

			t = control.lang(32010).encode('utf-8')
			k = control.keyboard('', t) ; k.doModal()
			q = k.getText() if k.isConfirmed() else None

			if (q == None or q == ''): return

			response = get(control.myaddon_link+'info/movie/search/%s'%q, headers=self.headers)
			data = json.loads(response.text)
			
			if "data" not in data:
				from resources.lib.modules import myaddon
				myaddon.myAddon().login(1)
				return 0
			self.moviesItems(data['data'])
		except:
			return

	def moviesItems(self, movies):
		userLang = control.apiLanguage(control.lang)["id"]
		for movie in movies:
			meta = movie["meta"]

			try:
				imdb = movie['imdb_id']
				title = movie['title']

				if 'plot' in meta:
					plot = meta['plot']
				else:
					plot = 0
				
				if userLang!="en":
					try:
						langData = control.getLangMeta("movie", imdb, 0, userLang)
						if "title" in langData:
							title = langData['title']
						if "overview" in langData:
							plot = langData['overview']
					except:
						pass

				title = title.encode('utf-8')
				plot = plot.encode('utf-8')

				year = movie['year']
				
				tmdb = movie['tmdb_id']
				if tmdb == None or tmdb == '' or tmdb == 'N/A': tmdb = '0'

				if 'poster' in meta:
					poster = meta['poster']
				else:
					poster = 0

				if 'fanart' in meta:
					fanart = meta['fanart']
				else:
					fanart = 0

				if 'released' in meta:
					premiered = meta['released'][0:10]
				else:
					premiered = '0'
				
				if 'genres' in meta:
					genre = meta['genres']
				else:
					genre = 0
				genre = genre.encode('utf-8')
			
				if 'runtime' in meta:
					duration = meta['runtime']
				else:
					duration = 0
				
				if 'rank' in meta:
					rating = meta['rank']
				else:
					rating = 0

				if 'votes' in meta:
					votes = meta['votes']
				else:
					votes = 0

				if 'director' in meta:
					director = meta['director']
				else:
					director = 0
				director = director.replace(', ', ' / ')
				director = director.encode('utf-8')
				
				if 'writer' in meta:
					writer = meta['writer']
				else:
					writer = 0
				writer = writer.replace(', ', ' / ')
				writer = writer.encode('utf-8')
				
				self.list.append({'imdb': imdb,'title': title, 'year': year, 'code': imdb, 'tmdb': tmdb, 'poster': poster, 'banner': '', 'fanart': fanart, 'premiered': premiered, 'studio': '', 'genre': genre, 'duration': duration, 'rating': rating, 'votes': votes, 'director': director, 'writer': writer, 'plot': plot})
			except: 
				print "####### ERROR JSON Movie: {0}".format(movie)
				pass
			
		self.movieDirectory(self.list)
		return self.list
	
	def moviesYear(self, param):
		param = int(param)
		try:
			response = get(control.myaddon_link+'info/movies/year/%d/0/300'%param, headers=self.headers)
			data = json.loads(response.text)
			if "data" not in data:
				print "### ERROR Load Movies Category JSON: {0}".format(param)
				return
			
			self.moviesItems(data['data'])
		except:
			return []
			pass
			
	def moviesCategory(self, category_id, page):
		try:
			response = get(control.myaddon_link+'info/movies/items/%s/%s/100'%(category_id,page), headers=self.headers)
			data = json.loads(response.text)
			if "data" not in data:
				print "### ERROR Load Movies Category JSON: {0}".format(category_id)
				return
			
			print "### ERROR Load Movies Category JSON: {0}".format(data)
			self.moviesItems(data['data']["infos"])
		except:
			return []
			pass

	def movieDirectory(self, items):
		if items == None or len(items) == 0: control.idle() ; sys.exit()

		sysaddon = sys.argv[0]
		syshandle = int(sys.argv[1])
		addonPoster, addonBanner = control.addonPoster(), control.addonBanner()
		addonFanart, settingFanart = control.addonFanart(), control.setting('fanart')
		
		imdbs = ""
		for i in items:
			if i==0:
				imdbs = i['imdb']
			else:
				imdbs = imdbs+","+i['imdb']
			
		response = get(control.myaddon_link+'history/%s'%(imdbs), headers=self.headers)
		hisotryJson = json.loads(response.text)
		historyArray = {}

		if "data" in hisotryJson:
			if hisotryJson["data"] is not None:
				for h in hisotryJson["data"]:
					if "seconds" in h["data"] and h["data"]["seconds"]>0:
						historyArray[h["imdb_id"]] = h["data"]["seconds"]
					if "watched" in h["data"] and h["data"]["watched"]==True:
						historyArray[h["imdb_id"]] = 999999

		response = get(control.myaddon_link+'favorite/movie', headers=self.headers)
		favoriteJson = json.loads(response.text)
		favoriteArray = {}
		
		if "data" in favoriteJson:
			if favoriteJson["data"] is not None:
				for fav in favoriteJson["data"]:
					favoriteArray[fav] = 1

		for i in items:
			try:
				label = '%s (%s)' % (i['title'], i['year'])
				imdb, title, year = i['imdb'], i['title'], i['year']
				sysname = urllib.quote_plus('%s (%s)' % (title, year))
				systitle = urllib.quote_plus(title)

				item = control.item(label=label)
				item.addStreamInfo('video', { 'width':1920 ,'height' : 1080 })
				item.setProperty("TotalTime", '')

				meta = {}
				meta.update({'mediatype': 'movie'})
				meta.update({'plot': i['plot']})
				meta.update({'title': i['title']})
				meta.update({'premiered': i['premiered']})

				try: meta.update({'duration': str(int(i['duration']) * 60)})
				except: meta.update({'duration': str(120 * 60)})
				
				try: meta.update({'genre': cleangenre.lang(meta['genre'], self.lang)})
				except: pass
				
				if 'poster' in i and not i['poster'] == '0':
					poster = i['poster']
				else:
					poster = 0
					
				
				ResumeTime = 0
				if imdb in historyArray:
					if historyArray[imdb]==999999:
						meta.update({'playcount': 1})
					else:
						item.setProperty("ResumeTime", str(historyArray[imdb]))
						ResumeTime = str(historyArray[imdb])
						
				art = {}

				if 'poster' in i and not i['poster'] == '0':
					art.update({'icon': i['poster'], 'thumb': i['poster'], 'poster': i['poster']})

				if 'banner' in i and not i['banner'] == '0':
					art.update({'banner': i['banner']})

				if settingFanart == 'true' and 'fanart' in i and not i['fanart'] == '0':
					item.setProperty('Fanart_Image', i['fanart'])
				
				contextMenuItems = []
				if imdb in favoriteArray:
					contextMenuItems.append(('Remove from My List', 'XBMC.RunPlugin(%s?action=movieMyList&param=0&imdb=%s)' % (sysaddon,imdb)))
				else:
					contextMenuItems.append(('Add to My List', 'XBMC.RunPlugin(%s?action=movieMyList&param=1&imdb=%s)' % (sysaddon,imdb)))
				
				item.setArt(art)
				item.addContextMenuItems(contextMenuItems, replaceItems=True)
				item.setInfo(type='Video', infoLabels = meta)
					
				url = '%s?action=moviePlay&imdb=%s&resumeTime=%s&title=%s&poster=%s&plot=%s' % (sysaddon, imdb, ResumeTime, systitle, poster, urllib.quote_plus(i['plot']))

				control.addItem(handle=syshandle, url=url, listitem=item, isFolder=False)
			except:
				pass

		control.content(syshandle, 'movies')
		control.directory(syshandle, cacheToDisc=True)
	
	def moviesMyList(self):
		response = get(control.myaddon_link+'favorite/movie', headers=self.headers)
		favoriteJson = json.loads(response.text)
		favoriteArray = []
		
		favs = ''
		if "data" in favoriteJson:
			if favoriteJson["data"] is not None:
				for fav in favoriteJson["data"]:
					favs += fav+","
				favs = favs[:-1]
				response = get(control.myaddon_link+'info/movie/%s'%favs, headers=self.headers)
				info = json.loads(response.text)
				if "data" in info:
					for mv in info["data"]: 
						favoriteArray.append(mv)
		self.moviesItems(favoriteArray)		