# -*- coding: utf-8 -*-
import os,sys,urlparse,xbmcgui,xbmc,json
from datetime import date, timedelta
from requests import get

from resources.lib.modules import control

sysaddon = sys.argv[0] ; syshandle = int(sys.argv[1])
artPath = control.artPath() ; addonFanart = control.addonFanart()

class navigator:
	def __init__(self):
		self.headers = {'Content-Type': 'application/json', 'Accept': 'application/json', 'X-API-VERSION': 'v2', 'Authorization': 'Bearer '+control.addon().getSetting('token')}

	def root(self):
		self.addDirectoryItem(32001, 'movieNav', 'movies.png', 'DefaultMovies.png')
		self.addDirectoryItem(32002, 'tvNav', 'tvshows.png', 'DefaultTVShows.png')
		self.addDirectoryItem(32007, 'channelsNav', 'channels.png', 'DefaultMovies.png')
		self.addDirectoryItem("TV Guide", 'tvguide', 'channels.png', 'DefaultMovies.png')
		self.addDirectoryItem("My List", 'myListNav', 'mymovies.png', 'DefaultFolder.png')
		self.addDirectoryItem(32010, 'searchNav', 'search.png', 'DefaultFolder.png')
		self.addDirectoryItem(32008, 'tools', 'tools.png', 'DefaultAddonProgram.png')
		self.endDirectory()

	def myListNav(self):
		self.addDirectoryItem(32003, 'moviesMyList', 'mymovies.png', 'DefaultMovies.png')
		self.addDirectoryItem(32004, 'tvshowsMyList', 'mytvshows.png', 'DefaultTVShows.png')
		self.addDirectoryItem(32006, 'episodesMyList', 'box-office.png', 'DefaultTVShows.png')
		self.addDirectoryItem("My channels", 'channelsMyList', 'box-office.png', 'DefaultTVShows.png')

		self.endDirectory()	
		
	def movies(self, lite=False):
		self.addDirectoryItem(32003, 'moviesMyList', 'mymovies.png', 'DefaultMovies.png')
		self.addDirectoryItem(32010, 'movieSearch', 'search.png', 'DefaultMovies.png')
		self.addDirectoryItem(32012, 'moviesYears', 'box-office.png', 'DefaultMovies.png')

		response = get(control.myaddon_link+'info/movies/categories', headers=self.headers)
		data = json.loads(response.text)
		if "data" in data:
			for cat in data["data"]: 
				self.addDirectoryItem(cat["name"], 'moviesCategory&category_id=%s&page=0'%cat["id"], 'box-office.png', 'DefaultMovies.png')
		else:
			from resources.lib.modules import myaddon
			myaddon.myAddon().login(1)
			return 0
		
		self.endDirectory()

	def channels(self, lite=False):
		self.addDirectoryItem("My channels", 'channelsMyList', 'box-office.png', 'DefaultTVShows.png')
		self.addDirectoryItem(32010, 'channelSearch', 'search.png', 'DefaultTVShows.png')
		response = get(control.myaddon_link+'info/livetv/categories', headers=self.headers)
		data = json.loads(response.text)
		if "data" in data:
			for cat in data["data"]: 
				self.addDirectoryItem(cat["name"], 'channelsCategory&category_id=%s'%cat["id"], 'box-office.png', 'DefaultMovies.png')
		else:
			from resources.lib.modules import myaddon
			myaddon.myAddon().login(1)
			return 0
		
		self.endDirectory()

	def tvshows(self, lite=False):
		self.addDirectoryItem(32004, 'tvshowsMyList', 'mytvshows.png', 'DefaultTVShows.png')
		self.addDirectoryItem("My Episdoes", 'episodesMyList', 'box-office.png', 'DefaultTVShows.png')
		self.addDirectoryItem(32006, 'episodesList', 'box-office.png', 'DefaultTVShows.png')
		self.addDirectoryItem(32027, 'episodesDate', 'box-office.png', 'DefaultTVShows.png')
		self.addDirectoryItem(32010, 'tvSearch', 'search.png', 'DefaultTVShows.png')
		self.addDirectoryItem(32012, 'tvshowsYears', 'box-office.png', 'DefaultTVShows.png')

		response = get(control.myaddon_link+'info/tvshows/categories', headers=self.headers)
		data = json.loads(response.text)
	
		if "data" in data:
			for cat in data["data"]: 
				self.addDirectoryItem(cat["name"], 'tvshowsCategory&category_id=%s&page=0'%cat["id"], 'box-office.png', 'DefaultMovies.png')
		else:
			from resources.lib.modules import myaddon
			myaddon.myAddon().login(1)
			return 0

		self.endDirectory()

	def tools(self):
		self.addDirectoryItem(32043, 'openSettings&query=0.0', 'tools.png', 'DefaultAddonProgram.png')
		self.addDirectoryItem(32044, 'openSettings&query=3.1', 'tools.png', 'DefaultAddonProgram.png')
		self.addDirectoryItem(32045, 'openSettings&query=1.0', 'tools.png', 'DefaultAddonProgram.png')
		self.addDirectoryItem(32046, 'openSettings&query=5.0', 'tools.png', 'DefaultAddonProgram.png')
		self.addDirectoryItem(32047, 'openSettings&query=2.0', 'tools.png', 'DefaultAddonProgram.png')
		self.addDirectoryItem(32048, 'openSettings&query=4.0', 'tools.png', 'DefaultAddonProgram.png')
		self.addDirectoryItem(32049, 'viewsNavigator', 'tools.png', 'DefaultAddonProgram.png')
		self.addDirectoryItem(32050, 'clearSources', 'tools.png', 'DefaultAddonProgram.png')
		self.addDirectoryItem(32052, 'clearCache', 'tools.png', 'DefaultAddonProgram.png')
		self.addDirectoryItem(32073, 'infoCheck', 'tools.png', 'DefaultAddonProgram.png', isFolder=False)
		self.endDirectory()


	def search(self):
		self.addDirectoryItem(32001, 'movieSearch', 'search.png', 'DefaultMovies.png')
		self.addDirectoryItem(32002, 'tvSearch', 'search.png', 'DefaultTVShows.png')
		self.addDirectoryItem(32007, 'channelSearch', 'search.png', 'DefaultTVShows.png')
		#self.addDirectoryItem(32029, 'moviePerson', 'people-search.png', 'DefaultMovies.png')
		#self.addDirectoryItem(32030, 'tvPerson', 'people-search.png', 'DefaultTVShows.png')

		self.endDirectory()

	def addDirectoryItem(self, name, query, thumb, icon, queue=False, isAction=True, isFolder=True):
		try: name = control.lang(name).encode('utf-8')
		except: pass
		url = '%s?action=%s' % (sysaddon, query) if isAction == True else query
		thumb = os.path.join(artPath, thumb) if not artPath == None else icon
		cm = []
		if queue == True: cm.append((queueMenu, 'RunPlugin(%s?action=queueItem)' % sysaddon))
		item = control.item(label=name)
		item.addContextMenuItems(cm)
		item.setArt({'icon': thumb, 'thumb': thumb})
		if not addonFanart == None: item.setProperty('Fanart_Image', addonFanart)
		control.addItem(handle=syshandle, url=url, listitem=item, isFolder=isFolder)


	def endDirectory(self):
		control.content(syshandle, 'addons')
		control.directory(syshandle, cacheToDisc=True)

	def moviesYears(self):
		for x in range(0, 50):
			self.addDirectoryItem("%s"%(2020-x), 'moviesYear&param=%s'%(2020-x), 'box-office.png', 'DefaultMovies.png')
		self.endDirectory()

	def tvshowsYears(self):
		for x in range(0, 40):
			self.addDirectoryItem("%s"%(2020-x), 'tvshowsYear&param=%s'%(2020-x), 'box-office.png', 'DefaultMovies.png')
		self.endDirectory()		

	def episodesDate(self):
		for x in range(0, 30):
			dateT = date.today() - timedelta(days=x)
			textT = dateT.strftime('%Y-%m-%d')
			self.addDirectoryItem("%s"%textT, 'episodesDateList&param=%s'%textT, 'box-office.png', 'DefaultMovies.png')
		self.endDirectory()				