#!/usr/bin/python

from requests import get
import xbmcgui, xbmc, os, json, glob
import xml.etree.ElementTree as ET
from xml.dom import minidom
from resources.lib.modules import control

try:
	from sqlite3 import dbapi2 as database
except:
	from pysqlite2 import dbapi2 as database

def sourceDB(libraryFolderMovies,libraryFolderTV):

	filelist = glob.glob(xbmc.translatePath(os.path.join('special://home/userdata/Database','MyVideos*.db')))
	if filelist != []:
		for f in filelist:
			databaseFile=f
	else:
		return False

	moviesSQL = "('"+libraryFolderMovies+"','movies','metadata.themoviedb.org','',2147483647,0,'<settings version=\"2\"><setting id=\"certprefix\" default=\"true\">Rated </setting><setting id=\"fanart\">true</setting><setting id=\"imdbanyway\" default=\"true\">false</setting><setting id=\"keeporiginaltitle\" default=\"true\">false</setting><setting id=\"language\" default=\"true\">"+control.addon().getSetting('wallLang')+"</setting><setting id=\"RatingS\">IMDb</setting><setting id=\"tmdbcertcountry\" default=\"true\">us</setting><setting id=\"trailer\">true</setting></settings>',0,0,NULL,NULL)"
	tvSQL = "('"+libraryFolderTV+"','tvshows','metadata.tvdb.com','',0,0,'<settings version=\"2\"><setting id=\"absolutenumber\" default=\"true\">false</setting><setting id=\"alsoimdb\" default=\"true\">false</setting><setting id=\"dvdorder\" default=\"true\">false</setting><setting id=\"fallback\">true</setting><setting id=\"fallbacklanguage\" default=\"true\">en</setting><setting id=\"fanart\">true</setting><setting id=\"language\" default=\"true\">"+control.addon().getSetting('wallLang')+"</setting><setting id=\"RatingS\">IMDb</setting><setting id=\"usefallbacklanguage1\">true</setting></settings>',0,0,NULL,NULL)"
	
	dbcon = database.connect(databaseFile)
	dbcur = dbcon.cursor()
	q = "INSERT OR REPLACE INTO path (strPath,strContent,strScraper,strHash,scanRecursive,useFolderNames,strSettings,noUpdate,exclude,dateAdded,idParentPath) VALUES "+ moviesSQL
	dbcur.execute(q)
	q = "INSERT OR REPLACE INTO path (strPath,strContent,strScraper,strHash,scanRecursive,useFolderNames,strSettings,noUpdate,exclude,dateAdded,idParentPath) VALUES "+ tvSQL
	dbcur.execute(q)
	dbcon.commit()
	return

def writeXML(file,root):
	rough_string = ET.tostring(root, 'utf-8')
	reparsed = minidom.parseString(rough_string)

	f = open(file, 'w')
	f.write(reparsed.toprettyxml(indent="  "))
	f.close()
	
def sourceXML(libraryFolderMovies,libraryFolderTV):
	xml_file = xbmc.translatePath(os.path.join('special://profile/','sources.xml'))
	
	if not os.path.exists(xml_file):
		root = ET.Element("sources")
		fields = ["programs","video","music","pictures","files"]
		for field in fields:
			sub = ET.SubElement(root, field)
			ET.SubElement(sub, "default", pathversion="1").text = ""
		writeXML(xml_file,root)
	
	tree = ET.parse(xml_file)
	root = tree.getroot()
	sources = root.find('video')

	mv_source = ET.SubElement(sources, 'source')
	ET.SubElement(mv_source, 'name').text = control.addon().getAddonInfo('name')+' Movies'
	ET.SubElement(mv_source, 'path', pathversion="1").text = libraryFolderMovies

	tv_source = ET.SubElement(sources, 'source')
	ET.SubElement(tv_source, 'name').text = control.addon().getAddonInfo('name')+' TV Shows'
	ET.SubElement(tv_source, 'path', pathversion="1").text = libraryFolderTV
	tree.write(xml_file)
	
def updateMovies(libraryFolderMovies,url):
	try:
		response = get(url, verify=False)
		json_object = json.loads(response.text)
	except:
		print "### ERROR Load JSON: {0}".format(json_object)
		return
		pass
	
	for movie in json_object['result']:
		movieFolder = xbmc.translatePath(os.path.join(libraryFolderMovies, movie["imdb"])).decode("utf-8")

		if not os.path.exists(movieFolder):
			try:
				os.makedirs(movieFolder)
			except:
				pass
			
			NFOFile = xbmc.translatePath(os.path.join(movieFolder, movie['imdb']+".nfo")).decode("utf-8")
			f = open(NFOFile, 'w')
			f.write("http://www.imdb.com/title/"+movie['imdb']+"/")
			f.close()
			
			StrFile = xbmc.translatePath(os.path.join(movieFolder, movie['imdb']+".strm")).decode("utf-8")
			f = open(StrFile, 'w')
			f.write("plugin://%s/?action=moviePlay&imdb=%s&title=%s"%(sys.argv[0],movie['imdb'],movie['title']))
			f.close()
			
			try:
				movieDate = int(movie['released'])
				os.utime(movieFolder,(movieDate,movieDate))
				os.utime(StrFile,(movieDate,movieDate))
				os.utime(NFOFile,(movieDate,movieDate))
			except:
				pass
	return

def updateTVShows(libraryFolderTV,url):
	try:
		response = get(url, verify=False)
		json_object = json.loads(response.text)
	except:
		print "### ERROR Load JSON: {0}".format(json_object)
		return
		pass
	
	for tv in json_object['result']:
		tvFolder = xbmc.translatePath(os.path.join(libraryFolderTV, tv["imdb"])).decode("utf-8")
		
		if not os.path.exists(tvFolder):
			try:
				os.makedirs(tvFolder)
				NFOFile = xbmc.translatePath(os.path.join(tvFolder, "tvshow.nfo")).decode("utf-8")
				f = open(NFOFile, 'w')
				f.write("http://thetvdb.com/index.php?tab=series&id="+tv['tvdb'])
				f.close()
			except:
				pass
		
		try:
			lastEpisode = xbmc.translatePath(os.path.join(libraryFolderTV, tv["imdb"], tv["imdb"]+" S%02dE%02d.strm"%(int(tv['seasons']['last']['season']),int(tv['seasons']['last']['episode'])))).decode("utf-8")
		except:
			lastEpisode = 99
			pass
			
		if lastEpisode==99 or not os.path.exists(lastEpisode):
			response = get(control.myaddon_static_link+'info/%s.json'%tv["imdb"], verify=False)
			json_tv = json.loads(response.text)

			try:
				for tvSeason in json_tv['result']['seasons']:
					for tvEpisode in json_tv['result']['seasons'][tvSeason]:
						scanEpisode = xbmc.translatePath(os.path.join(libraryFolderTV, tv["imdb"], tv["imdb"]+" S%02dE%02d.strm"%(int(tvSeason),int(tvEpisode)))).decode("utf-8")
						if not os.path.exists(scanEpisode):
							f = open(scanEpisode, 'w')
							f.write("plugin://program.apollo/?action=myaddon&imdb=%s&season=%s&episode=%s&title=%s&year=%s"%(tv['imdb'],tvSeason,tvEpisode,tv['title'],tv['year']))
							f.close()
							try:
								episodeDate = int(json_tv['result']['seasons'][tvSeason][tvEpisode]["released"])
								os.utime(scanEpisode,(episodeDate,episodeDate))
							except:
								pass
			except:
				pass

libraryFolderMovies = "special://userdata/addon_data/"+control.addon().getAddonInfo('id')+"/wall/movies/"
libraryFolderTV = "special://userdata/addon_data/"+control.addon().getAddonInfo('id')+"/wall/tv/"

def runWall():
	if control.addon().getSetting('wall')=="true":

		if control.addon().getSetting('firstWall')=="true":
			i = control.dialog.yesno(control.addon().getAddonInfo('name'),"Are you sure you want to use VOD Wall? You need strong device and memory to use it.")
			if i == 1:
				sourceXML(libraryFolderMovies,libraryFolderTV)
				sourceDB(libraryFolderMovies,libraryFolderTV)
				control.addon().setSetting('firstWall', "false")
				control.dialog.ok(control.addon().getAddonInfo('name'),"Please restart your device for these settings to take effect")
			else:
				control.addon().setSetting('wall', "false")
		else:
			xbmc.executebuiltin('Notification('+control.addon().getAddonInfo('name')+',"Updating your VOD Wall. This will take a while.", {0}, {1})'.format(4500,os.path.join( control.addonPath ,"icon.png")))
			if control.addon().getSetting('wallMvPopular')=="true":
				updateMovies(libraryFolderMovies, control.myaddon_static_link+'list/movie/popular.json')
			if control.addon().getSetting('wallMvTrending')=="true":
				updateMovies(libraryFolderMovies, control.myaddon_static_link+'list/movie/trending.json')
			if control.addon().getSetting('wallMvViews')=="true":
				updateMovies(libraryFolderMovies, control.myaddon_static_link+'list/movie/views.json')
			if control.addon().getSetting('wallMvRecent')=="true":
				updateMovies(libraryFolderMovies, control.myaddon_static_link+'list/movie/recent.json')
			if control.addon().getSetting('wallMvBox')=="true":
				updateMovies(libraryFolderMovies, control.myaddon_static_link+'list/movie/box.json')
			if control.addon().getSetting('wallMvOscars')=="true":
				updateMovies(libraryFolderMovies, control.myaddon_static_link+'list/movie/oscars.json')
			if control.addon().getSetting('wallMvTrending')=="true":
				updateMovies(libraryFolderMovies, control.myaddon_static_link+'list/movie/theaters.json')

			if control.addon().getSetting('wallTVPopular')=="true":
				updateTVShows(libraryFolderTV, control.myaddon_static_link+'list/tv/popular.json')
			if control.addon().getSetting('wallTVTrending')=="true":
				updateTVShows(libraryFolderTV, control.myaddon_static_link+'list/tv/trending.json')
			if control.addon().getSetting('wallTVPremiere')=="true":
				updateTVShows(libraryFolderTV, control.myaddon_static_link+'list/tv/premiere.json')
			if control.addon().getSetting('wallTVRecent')=="true":
				updateTVShows(libraryFolderTV, control.myaddon_static_link+'list/tv/recent.json')
			if control.addon().getSetting('wallTVViews')=="true":
				updateTVShows(libraryFolderTV, control.myaddon_static_link+'list/tv/views.json')
			if control.addon().getSetting('wallTVRating')=="true":
				updateTVShows(libraryFolderTV, control.myaddon_static_link+'list/tv/rating.json')

			xbmc.executebuiltin('Notification('+control.addon().getAddonInfo('name')+',"Grabbing VOD wall info. This will take a while.", {0}, {1})'.format(4500,os.path.join( control.addonPath ,"icon.png")))
			xbmc.executebuiltin('XBMC.UpdateLibrary(video,{0})'.format(libraryFolderMovies))
			while xbmc.getCondVisibility('Library.IsScanningVideo') == True:
				xbmc.sleep(10000)
			xbmc.executebuiltin('XBMC.UpdateLibrary(video,{0})'.format(libraryFolderTV))